/*
 * Decompiled with CFR 0.152.
 */
package com.uuzuche.lib_zxing.decoding;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.uuzuche.lib_zxing.R;
import com.uuzuche.lib_zxing.activity.CaptureFragment;
import com.uuzuche.lib_zxing.camera.CameraManager;
import com.uuzuche.lib_zxing.decoding.DecodeThread;
import com.uuzuche.lib_zxing.view.ViewfinderResultPointCallback;
import com.uuzuche.lib_zxing.view.ViewfinderView;
import java.util.Vector;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    private final CaptureFragment fragment;
    private final DecodeThread decodeThread;
    private State state;

    public CaptureActivityHandler(CaptureFragment fragment, Vector<BarcodeFormat> decodeFormats, String characterSet, ViewfinderView viewfinderView) {
        this.fragment = fragment;
        this.decodeThread = new DecodeThread(fragment, decodeFormats, characterSet, new ViewfinderResultPointCallback(viewfinderView));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        CameraManager.get().startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == R.id.auto_focus) {
            if (this.state == State.PREVIEW) {
                CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            }
        } else if (message.what == R.id.restart_preview) {
            Log.d((String)TAG, (String)"Got restart preview message");
            this.restartPreviewAndDecode();
        } else if (message.what == R.id.decode_succeeded) {
            Log.d((String)TAG, (String)"Got decode succeeded message");
            this.state = State.SUCCESS;
            Bundle bundle = message.getData();
            Bitmap barcode = bundle == null ? null : (Bitmap)bundle.getParcelable("barcode_bitmap");
            this.fragment.handleDecode((Result)message.obj, barcode);
        } else if (message.what == R.id.decode_failed) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), R.id.decode);
        } else if (message.what == R.id.return_scan_result) {
            Log.d((String)TAG, (String)"Got return scan result message");
            this.fragment.getActivity().setResult(-1, (Intent)message.obj);
            this.fragment.getActivity().finish();
        } else if (message.what == R.id.launch_product_query) {
            Log.d((String)TAG, (String)"Got product query message");
            String url = (String)message.obj;
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(524288);
            this.fragment.getActivity().startActivity(intent);
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        CameraManager.get().stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)R.id.quit);
        quit.sendToTarget();
        try {
            this.decodeThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(R.id.decode_succeeded);
        this.removeMessages(R.id.decode_failed);
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), R.id.decode);
            CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            this.fragment.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

