/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.list;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import cn.yhq.adapter.core.ViewHolder;
import cn.yhq.adapter.core.ViewHolderFactory;
import cn.yhq.adapter.list.IItemViewProvider;
import cn.yhq.adapter.list.IItemViewProviderKeyPolicy;
import cn.yhq.adapter.list.ItemViewProvider1;
import cn.yhq.adapter.list.ItemViewProvider2;
import cn.yhq.adapter.list.ItemViewProviderFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAdapter<L, I>
extends android.widget.BaseAdapter {
    protected L mListData;
    private ItemViewProviderFactory<I> mItemViewProviderFactory;
    protected Context mContext;

    public BaseAdapter(Context context, L listData) {
        this.mContext = context;
        this.mListData = listData == null ? this.newInstance() : listData;
        this.mItemViewProviderFactory = new ItemViewProviderFactory(context, this);
    }

    protected abstract L newInstance();

    public BaseAdapter(Context context) {
        this(context, null);
    }

    public static <T extends ViewHolder> void setViewHolderFactory(ViewHolderFactory<T> factory) {
        ItemViewProviderFactory.setViewHolderFactory(factory);
    }

    public final BaseAdapter<L, I> register(int key, ItemViewProvider1<I> itemViewProvider) {
        this.mItemViewProviderFactory.register(key, itemViewProvider);
        return this;
    }

    public BaseAdapter<L, I> register(int key, Class<? extends ItemViewProvider1<I>> itemViewProviderClass) {
        this.mItemViewProviderFactory.register(key, itemViewProviderClass);
        return this;
    }

    public final BaseAdapter<L, I> setItemViewProviderKeyPolicy(IItemViewProviderKeyPolicy<I> itemViewProviderKeyPolicy) {
        this.mItemViewProviderFactory.setItemViewProviderKeyPolicy(itemViewProviderKeyPolicy);
        return this;
    }

    public final BaseAdapter<L, I> register(ItemViewProvider2<I> itemViewProvider) {
        this.mItemViewProviderFactory.register(itemViewProvider);
        return this;
    }

    public final BaseAdapter<L, I> register(Class<? extends ItemViewProvider2<I>> itemViewProviderClass) {
        this.mItemViewProviderFactory.register(itemViewProviderClass);
        return this;
    }

    public final <T extends IItemViewProvider<I>> List<T> getAllItemViewProvider() {
        List<ItemViewProvider1<I>> providers = this.mItemViewProviderFactory.getAllItemViewProvider();
        ArrayList<IItemViewProvider> list = new ArrayList<IItemViewProvider>();
        for (IItemViewProvider iItemViewProvider : providers) {
            list.add(iItemViewProvider);
        }
        return list;
    }

    public abstract void clearAllItem();

    public abstract void addAllItem(L var1);

    public abstract void addItem(I var1);

    public abstract void removeItem(I var1);

    public abstract void removeItem(int var1);

    public final L getListData() {
        return this.mListData;
    }

    public final void setListData(L dataList) {
        this.mListData = dataList;
    }

    public abstract I getItem(int var1);

    public long getItemId(int position) {
        return position;
    }

    public final int getItemViewType(int position) {
        return this.mItemViewProviderFactory.getItemViewType(position, this.getItem(position));
    }

    public final int getViewTypeCount() {
        return this.mItemViewProviderFactory.getItemViewTypeCount();
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        return this.mItemViewProviderFactory.setupView(position, this.getItem(position), convertView, parent);
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final ItemViewProviderFactory<I> getItemViewProviderFactory() {
        return this.mItemViewProviderFactory;
    }

    public final ItemViewProvider1<I> getItemViewProvider(int key) {
        return this.mItemViewProviderFactory.getItemViewProviderByKey(key);
    }
}

