/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.core;

import android.content.Context;
import android.util.SparseArray;
import cn.yhq.adapter.core.ItemView;
import java.util.ArrayList;
import java.util.List;

public final class ItemViewContainer<Adapter> {
    private Adapter mAdapter;
    private SparseArray<ItemView<Adapter>> mItemViews = new SparseArray();
    private SparseArray<Integer> mItemViewKeys = new SparseArray();
    private Context mContext;

    public ItemViewContainer(Context context, Adapter adapter) {
        this.mAdapter = adapter;
        this.mContext = context;
    }

    public int getSize() {
        return this.mItemViews.size();
    }

    public ItemView<Adapter> getByKey(int key) {
        if (this.mItemViewKeys.indexOfKey(key) == -1) {
            return null;
        }
        return this.getByType((Integer)this.mItemViewKeys.get(key));
    }

    public ItemView<Adapter> getByType(int type) {
        return (ItemView)this.mItemViews.get(type);
    }

    public List<ItemView<Adapter>> getAll() {
        ArrayList<ItemView<Adapter>> list = new ArrayList<ItemView<Adapter>>();
        for (int i = 0; i < this.mItemViews.size(); ++i) {
            list.add((ItemView<Adapter>)this.mItemViews.get(this.mItemViews.keyAt(i)));
        }
        return list;
    }

    private void initItemView(ItemView<Adapter> itemView) {
        int type = this.getSize();
        itemView.create(type, this.mContext, this.mAdapter);
    }

    private ItemView<Adapter> newInstance(Class<? extends ItemView<Adapter>> itemViewClass) {
        try {
            ItemView<Adapter> itemViewType = itemViewClass.newInstance();
            return itemViewType;
        }
        catch (Exception e) {
            try {
                ItemView itemViewType = (ItemView)itemViewClass.getConstructors()[0].newInstance(this.mAdapter);
                return itemViewType;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public ItemView<Adapter> put(int key, Class<? extends ItemView<Adapter>> type) {
        ItemView<Adapter> itemView = this.newInstance(type);
        if (itemView == null) {
            return null;
        }
        return this.put(key, itemView);
    }

    public ItemView<Adapter> put(Class<? extends ItemView<Adapter>> type) {
        ItemView<Adapter> itemView = this.newInstance(type);
        if (itemView == null) {
            return null;
        }
        return this.put(itemView);
    }

    public ItemView<Adapter> put(int key, ItemView<Adapter> itemView) {
        itemView = this.put(itemView);
        this.mItemViewKeys.put(key, (Object)itemView.getType());
        return itemView;
    }

    public ItemView<Adapter> put(ItemView<Adapter> itemView) {
        this.initItemView(itemView);
        this.mItemViews.put(itemView.getType(), itemView);
        return itemView;
    }
}

