/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.expand;

import android.content.Context;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import cn.yhq.adapter.expand.ChildItemViewProvider1;
import cn.yhq.adapter.expand.ChildItemViewProvider2;
import cn.yhq.adapter.expand.ChildItemViewProviderFactory;
import cn.yhq.adapter.expand.GroupItemViewProvider1;
import cn.yhq.adapter.expand.GroupItemViewProvider2;
import cn.yhq.adapter.expand.GroupItemViewProviderFactory;
import cn.yhq.adapter.expand.IChildItemViewProvider;
import cn.yhq.adapter.expand.IChildItemViewProviderKeyPolicy;
import cn.yhq.adapter.expand.IGroupItemViewProvider;
import cn.yhq.adapter.expand.IGroupItemViewProviderKeyPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseExpandableAdapter<L, G, C>
extends BaseExpandableListAdapter {
    protected L mListData;
    private GroupItemViewProviderFactory<G> mGroupItemViewProviderFactory;
    private ChildItemViewProviderFactory<G, C> mChildItemViewProviderFactory;
    protected Context mContext;
    protected SparseBooleanArray mExpandState = new SparseBooleanArray();

    public BaseExpandableAdapter(Context context, L listData) {
        this.mContext = context;
        this.mListData = listData == null ? this.newInstance() : listData;
        this.mGroupItemViewProviderFactory = new GroupItemViewProviderFactory(this.getContext(), this);
        this.mChildItemViewProviderFactory = new ChildItemViewProviderFactory(this.getContext(), this);
    }

    protected abstract L newInstance();

    public BaseExpandableAdapter(Context context) {
        this(context, null);
    }

    public final BaseExpandableAdapter<L, G, C> setGroupItemViewProviderKeyPolicy(IGroupItemViewProviderKeyPolicy<G> itemViewProviderKeyPolicy) {
        this.mGroupItemViewProviderFactory.setGroupItemViewProviderKeyPolicy(itemViewProviderKeyPolicy);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> register(int key, GroupItemViewProvider1<G> itemViewProvider) {
        this.mGroupItemViewProviderFactory.register(key, itemViewProvider);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> registerGroupViewProvider(int key, Class<? extends GroupItemViewProvider1<G>> itemViewProviderClass) {
        this.mGroupItemViewProviderFactory.register(key, itemViewProviderClass);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> register(GroupItemViewProvider2<G> itemViewProvider) {
        this.mGroupItemViewProviderFactory.register(itemViewProvider);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> registerGroupViewProvider(Class<? extends GroupItemViewProvider2<G>> itemViewProviderClass) {
        this.mGroupItemViewProviderFactory.register(itemViewProviderClass);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> setChildItemViewProviderKeyPolicy(IChildItemViewProviderKeyPolicy<G, C> itemViewProviderKeyPolicy) {
        this.mChildItemViewProviderFactory.setChildItemViewProviderKeyPolicy(itemViewProviderKeyPolicy);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> register(int key, ChildItemViewProvider1<G, C> itemViewProvider) {
        this.mChildItemViewProviderFactory.register(key, itemViewProvider);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> registerChildViewProvider(int key, Class<? extends ChildItemViewProvider1<G, C>> itemViewProviderClass) {
        this.mChildItemViewProviderFactory.register(key, itemViewProviderClass);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> register(ChildItemViewProvider2<G, C> itemViewProvider) {
        this.mChildItemViewProviderFactory.register(itemViewProvider);
        return this;
    }

    public final BaseExpandableAdapter<L, G, C> registerChildViewProvider(Class<? extends ChildItemViewProvider2<G, C>> itemViewProviderClass) {
        this.mChildItemViewProviderFactory.register(itemViewProviderClass);
        return this;
    }

    public abstract void clearAllItem();

    public abstract void addAllItem(L var1);

    public abstract void addItem(G var1);

    public abstract void removeItem(G var1);

    public abstract void removeItem(int var1);

    public final L getListData() {
        return this.mListData;
    }

    public final void setListData(L dataList) {
        this.mListData = dataList;
    }

    public abstract G getGroup(int var1);

    public abstract C getChild(int var1, int var2);

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public final View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        this.mExpandState.put(groupPosition, isExpanded);
        return this.mGroupItemViewProviderFactory.setupView(groupPosition, this.getGroup(groupPosition), convertView, parent, isExpanded);
    }

    public final View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        return this.mChildItemViewProviderFactory.setupView(groupPosition, this.getGroup(groupPosition), childPosition, this.getChild(groupPosition, childPosition), convertView, parent);
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public final int getChildType(int groupPosition, int childPosition) {
        return this.mChildItemViewProviderFactory.getItemViewType(groupPosition, this.getGroup(groupPosition), childPosition, this.getChild(groupPosition, childPosition));
    }

    public final int getChildTypeCount() {
        return this.mChildItemViewProviderFactory.getItemViewTypeCount();
    }

    public final int getGroupType(int groupPosition) {
        return this.mGroupItemViewProviderFactory.getItemViewType(groupPosition, this.getGroup(groupPosition));
    }

    public final int getGroupTypeCount() {
        return this.mGroupItemViewProviderFactory.getItemViewTypeCount();
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final boolean isExpand(int groupPosition) {
        return this.mExpandState.get(groupPosition, false);
    }

    public final <T extends IGroupItemViewProvider<G>> List<T> getAllGroupItemViewProvider() {
        List<GroupItemViewProvider1<G>> providers = this.mGroupItemViewProviderFactory.getAllItemViewProvider();
        ArrayList<IGroupItemViewProvider> list = new ArrayList<IGroupItemViewProvider>();
        for (IGroupItemViewProvider iGroupItemViewProvider : providers) {
            list.add(iGroupItemViewProvider);
        }
        return list;
    }

    public final <T extends IChildItemViewProvider<G, C>> List<T> getAllChildItemViewProvider() {
        List<ChildItemViewProvider1<G, C>> providers = this.mChildItemViewProviderFactory.getAllItemViewProvider();
        ArrayList<IChildItemViewProvider> list = new ArrayList<IChildItemViewProvider>();
        for (IChildItemViewProvider iChildItemViewProvider : providers) {
            list.add(iChildItemViewProvider);
        }
        return list;
    }

    public final GroupItemViewProviderFactory<G> getGroupItemViewProviderFactory() {
        return this.mGroupItemViewProviderFactory;
    }

    public final ChildItemViewProviderFactory<G, C> getChildItemViewProviderFactory() {
        return this.mChildItemViewProviderFactory;
    }

    public final IGroupItemViewProvider<G> getGroupItemViewProvider(int key) {
        return this.mGroupItemViewProviderFactory.getItemViewProviderByKey(key);
    }

    public final IChildItemViewProvider<G, C> getChildItemViewProvider(int key) {
        return this.mChildItemViewProviderFactory.getItemViewProviderByKey(key);
    }
}

