/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.list;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import cn.yhq.adapter.core.IItemViewKeyPolicy;
import cn.yhq.adapter.core.IItemViewSelector;
import cn.yhq.adapter.core.ItemViewFactory;
import cn.yhq.adapter.core.ViewHolder;
import cn.yhq.adapter.list.IItemViewProviderKeyPolicy;
import cn.yhq.adapter.list.IItemViewProviderSelector;
import cn.yhq.adapter.list.ItemViewProvider1;
import java.util.List;

public final class ItemViewProviderFactory<T>
extends ItemViewFactory<BaseAdapter, ItemViewProvider1<T>> {
    private IItemViewProviderKeyPolicy<T> mItemViewProviderKeyPolicy;

    public ItemViewProviderFactory(Context context, BaseAdapter adapter) {
        super(context, adapter);
    }

    public final void setItemViewProviderKeyPolicy(IItemViewProviderKeyPolicy<T> itemViewProviderKeyPolicy) {
        this.mItemViewProviderKeyPolicy = itemViewProviderKeyPolicy;
    }

    private final ItemViewProvider1<T> obtainItemViewProvider(final int position, final T entity) {
        return (ItemViewProvider1)this.obtainItemView(new IItemViewKeyPolicy(){

            @Override
            public int getItemViewKey() {
                if (ItemViewProviderFactory.this.mItemViewProviderKeyPolicy != null) {
                    return ItemViewProviderFactory.this.mItemViewProviderKeyPolicy.getItemViewProviderKey(position, entity);
                }
                return -1;
            }
        }, new IItemViewSelector<ItemViewProvider1<T>>(){

            @Override
            public boolean isForItemView(ItemViewProvider1<T> itemView) {
                if (itemView instanceof IItemViewProviderSelector) {
                    return ((IItemViewProviderSelector)((Object)itemView)).isForProvider(position, entity);
                }
                return false;
            }
        });
    }

    public final List<ItemViewProvider1<T>> getAllItemViewProvider() {
        return this.getAllItemView();
    }

    public final int getItemViewType(int position, T entity) {
        return this.obtainItemViewProvider(position, entity).getType();
    }

    public final int getItemViewTypeCount() {
        return this.getItemViewSize();
    }

    public final View setupView(int position, T entity, View convertView, ViewGroup parent) {
        try {
            ItemViewProvider1<T> itemViewProvider = this.obtainItemViewProvider(position, entity);
            int layoutId = itemViewProvider.getItemViewLayoutId();
            ViewHolder viewHolder = ViewHolder.get(this.mContext, convertView, parent, layoutId, position);
            itemViewProvider.setupView(viewHolder, position, entity);
            return viewHolder.getConvertView();
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return new View(this.mContext);
        }
    }

    public final ItemViewProvider1<T> getItemViewProviderByKey(int key) {
        return (ItemViewProvider1)this.getItemViewByKey(key);
    }
}

