/*
 * Decompiled with CFR 0.152.
 */
package cn.ycbjie.ycstatusbarlib.dlBar;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.ycbjie.ycstatusbarlib.utils.StatusBarUtils;
import cn.ycbjie.ycstatusbarlib.view.StatusBarView;

public class DlStatusBar {
    public static void setColorNoTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color2) {
        StatusBarUtils.checkNull(activity);
        DlStatusBar.setColorForDrawerLayout(activity, drawerLayout, color2, 0);
    }

    public static void setColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color2, int statusBarAlpha) {
        StatusBarUtils.checkNull(activity);
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        if (contentLayout.getChildCount() > 0 && contentLayout.getChildAt(0) instanceof StatusBarView) {
            contentLayout.getChildAt(0).setBackgroundColor(DlStatusBar.calculateStatusColor(color2, statusBarAlpha));
        } else {
            StatusBarView statusBarView = DlStatusBar.createStatusBarView(activity, color2);
            contentLayout.addView((View)statusBarView, 0);
        }
        if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
            contentLayout.getChildAt(1).setPadding(contentLayout.getPaddingLeft(), statusBarHeight + contentLayout.getPaddingTop(), contentLayout.getPaddingRight(), contentLayout.getPaddingBottom());
        }
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        contentLayout.setFitsSystemWindows(false);
        contentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
        DlStatusBar.addTranslucentView(activity, statusBarAlpha);
    }

    private static StatusBarView createStatusBarView(Activity activity, @ColorInt int color2) {
        StatusBarUtils.checkNull(activity);
        StatusBarView statusBarView = new StatusBarView((Context)activity);
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, statusBarHeight);
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(color2);
        return statusBarView;
    }

    private static void addTranslucentView(Activity activity, int statusBarAlpha) {
        StatusBarUtils.checkNull(activity);
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        if (contentView.getChildCount() > 1) {
            contentView.getChildAt(1).setBackgroundColor(Color.argb((int)statusBarAlpha, (int)0, (int)0, (int)0));
        } else {
            contentView.addView((View)DlStatusBar.createTranslucentStatusBarView(activity, statusBarAlpha));
        }
    }

    private static StatusBarView createTranslucentStatusBarView(Activity activity, int alpha) {
        StatusBarUtils.checkNull(activity);
        StatusBarView statusBarView = new StatusBarView((Context)activity);
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, statusBarHeight);
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
        return statusBarView;
    }

    private static int calculateStatusColor(@ColorInt int color2, int alpha) {
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color2 >> 16 & 0xFF;
        int green = color2 >> 8 & 0xFF;
        int blue = color2 & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

