/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.ycprogresslib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.ns.yc.ycprogresslib.OnNumberProgressListener;
import com.ns.yc.ycprogresslib.ProgressBarUtils;
import com.ns.yc.ycprogresslib.R;

public class NumberProgressbar
extends View {
    private int mMaxProgress = 100;
    private int mCurrentProgress = 0;
    private int mReachedBarColor;
    private int mUnreachedBarColor;
    private int mTextColor;
    private float mTextSize;
    private float mReachedBarHeight;
    private float mUnreachedBarHeight;
    private String mSuffix = "%";
    private String mPrefix = "";
    private float mDrawTextStart;
    private float mDrawTextEnd;
    private String mCurrentDrawText;
    private Paint mReachedBarPaint;
    private Paint mUnreachedBarPaint;
    private Paint mTextPaint;
    private RectF mUnreachedRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private RectF mReachedRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private float mOffset;
    private boolean mDrawUnreachedBar = true;
    private boolean mDrawReachedBar = true;
    private boolean mTextIsVisible = true;
    private long timeMillis = 0L;
    private Runnable progressChangeTask = new Runnable(){

        @Override
        public void run() {
            NumberProgressbar.this.removeCallbacks(this);
            NumberProgressbar.this.mCurrentProgress = NumberProgressbar.this.mCurrentProgress + 1;
            if (NumberProgressbar.this.mCurrentProgress >= 0 && NumberProgressbar.this.mCurrentProgress <= 100) {
                if (NumberProgressbar.this.mListener != null) {
                    NumberProgressbar.this.mListener.onProgressChange(NumberProgressbar.this.mCurrentProgress, NumberProgressbar.this.mMaxProgress);
                }
                NumberProgressbar.this.invalidate();
                if (NumberProgressbar.this.timeMillis == 0L) {
                    NumberProgressbar.this.postDelayed(NumberProgressbar.this.progressChangeTask, 500L);
                } else {
                    NumberProgressbar.this.postDelayed(NumberProgressbar.this.progressChangeTask, NumberProgressbar.this.timeMillis / 100L);
                }
            } else {
                NumberProgressbar.this.mCurrentProgress = NumberProgressbar.this.validateProgress(NumberProgressbar.this.mCurrentProgress);
            }
        }
    };
    private OnNumberProgressListener mListener;

    public NumberProgressbar(Context context) {
        this(context, null);
    }

    public NumberProgressbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberProgressbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeAttrs(context, attrs, defStyleAttr);
        this.initializePainters();
    }

    protected void onDraw(Canvas canvas) {
        this.drawCanvas(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidth = this.measure(widthMeasureSpec, true);
        int measureHeight = this.measure(heightMeasureSpec, false);
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    private void initializeAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.NumberProgressbar, defStyleAttr, 0);
        this.mReachedBarColor = attributes.getColor(R.styleable.NumberProgressbar_progress_reached_color, -7829368);
        this.mUnreachedBarColor = attributes.getColor(R.styleable.NumberProgressbar_progress_unreached_color, -12303292);
        this.mTextColor = attributes.getColor(R.styleable.NumberProgressbar_progress_text_color, -16777216);
        this.mTextSize = attributes.getDimension(R.styleable.NumberProgressbar_progress_text_size, ProgressBarUtils.sp2px(context, 12.0f));
        this.mReachedBarHeight = attributes.getDimension(R.styleable.NumberProgressbar_progress_reached_bar_height, ProgressBarUtils.dp2px(context, 1.5f));
        this.mUnreachedBarHeight = attributes.getDimension(R.styleable.NumberProgressbar_progress_unreached_bar_height, ProgressBarUtils.dp2px(context, 1.0f));
        this.mOffset = attributes.getDimension(R.styleable.NumberProgressbar_progress_text_offset, ProgressBarUtils.dp2px(context, 2.0f));
        int textVisible = attributes.getInt(R.styleable.NumberProgressbar_progress_text_visibility, 0);
        if (textVisible != 0) {
            this.mTextIsVisible = false;
        }
        this.setProgress(attributes.getInt(R.styleable.NumberProgressbar_progress_current, 0));
        this.setMax(attributes.getInt(R.styleable.NumberProgressbar_progress_max, 100));
        attributes.recycle();
    }

    private void initializePainters() {
        this.mReachedBarPaint = new Paint(1);
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.mUnreachedBarPaint = new Paint(1);
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
    }

    protected int getSuggestedMinimumWidth() {
        return (int)this.mTextSize;
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max((int)this.mTextSize, Math.max((int)this.mReachedBarHeight, (int)this.mUnreachedBarHeight));
    }

    private int measure(int measureSpec, boolean isWidth) {
        int result;
        int padding;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int n = padding = isWidth ? this.getPaddingLeft() + this.getPaddingRight() : this.getPaddingTop() + this.getPaddingBottom();
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = isWidth ? this.getSuggestedMinimumWidth() : this.getSuggestedMinimumHeight();
            result += padding;
            if (mode == Integer.MIN_VALUE) {
                result = isWidth ? Math.max(result, size) : Math.min(result, size);
            }
        }
        return result;
    }

    private void drawCanvas(Canvas canvas) {
        if (this.mTextIsVisible) {
            this.calculateDrawRectF();
        } else {
            this.calculateDrawRectFWithoutProgressText();
        }
        if (this.mDrawReachedBar) {
            canvas.drawRect(this.mReachedRectF, this.mReachedBarPaint);
        }
        if (this.mDrawUnreachedBar) {
            canvas.drawRect(this.mUnreachedRectF, this.mUnreachedBarPaint);
        }
        if (this.mTextIsVisible) {
            canvas.drawText(this.mCurrentDrawText, this.mDrawTextStart, this.mDrawTextEnd, this.mTextPaint);
        }
    }

    private void calculateDrawRectFWithoutProgressText() {
        this.mReachedRectF.left = this.getPaddingLeft();
        this.mReachedRectF.top = (float)this.getHeight() / 2.0f - this.mReachedBarHeight / 2.0f;
        this.mReachedRectF.right = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / ((float)this.mMaxProgress * 1.0f) * (float)this.mCurrentProgress + (float)this.getPaddingLeft();
        this.mReachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mReachedBarHeight / 2.0f;
        this.mUnreachedRectF.left = this.mReachedRectF.right;
        this.mUnreachedRectF.right = this.getWidth() - this.getPaddingRight();
        this.mUnreachedRectF.top = (float)this.getHeight() / 2.0f + -this.mUnreachedBarHeight / 2.0f;
        this.mUnreachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mUnreachedBarHeight / 2.0f;
    }

    @SuppressLint(value={"DefaultLocale"})
    private void calculateDrawRectF() {
        float unreachedBarStart;
        this.mCurrentDrawText = String.format("%d", this.mCurrentProgress * 100 / this.mMaxProgress);
        this.mCurrentDrawText = this.mPrefix + this.mCurrentDrawText + this.mSuffix;
        float mDrawTextWidth = this.mTextPaint.measureText(this.mCurrentDrawText);
        if (this.mCurrentProgress == 0) {
            this.mDrawReachedBar = false;
            this.mDrawTextStart = this.getPaddingLeft();
        } else {
            this.mDrawReachedBar = true;
            this.mReachedRectF.left = this.getPaddingLeft();
            this.mReachedRectF.top = (float)this.getHeight() / 2.0f - this.mReachedBarHeight / 2.0f;
            this.mReachedRectF.right = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / ((float)this.mMaxProgress * 1.0f) * (float)this.mCurrentProgress - this.mOffset + (float)this.getPaddingLeft();
            this.mReachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mReachedBarHeight / 2.0f;
            this.mDrawTextStart = this.mReachedRectF.right + this.mOffset;
        }
        this.mDrawTextEnd = (int)((float)this.getHeight() / 2.0f - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
        if (this.mDrawTextStart + mDrawTextWidth >= (float)(this.getWidth() - this.getPaddingRight())) {
            this.mDrawTextStart = (float)(this.getWidth() - this.getPaddingRight()) - mDrawTextWidth;
            this.mReachedRectF.right = this.mDrawTextStart - this.mOffset;
        }
        if ((unreachedBarStart = this.mDrawTextStart + mDrawTextWidth + this.mOffset) >= (float)(this.getWidth() - this.getPaddingRight())) {
            this.mDrawUnreachedBar = false;
        } else {
            this.mDrawUnreachedBar = true;
            this.mUnreachedRectF.left = unreachedBarStart;
            this.mUnreachedRectF.right = this.getWidth() - this.getPaddingRight();
            this.mUnreachedRectF.top = (float)this.getHeight() / 2.0f + -this.mUnreachedBarHeight / 2.0f;
            this.mUnreachedRectF.bottom = (float)this.getHeight() / 2.0f + this.mUnreachedBarHeight / 2.0f;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    public void start() {
        this.stop();
        this.post(this.progressChangeTask);
    }

    public void reStart() {
        this.mCurrentProgress = 0;
        this.start();
    }

    public void stop() {
        if (this.progressChangeTask != null) {
            this.removeCallbacks(this.progressChangeTask);
        }
    }

    private int validateProgress(int progress) {
        if (progress > 100) {
            progress = 100;
        } else if (progress < 0) {
            progress = 0;
        }
        return progress;
    }

    public void setProgressTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mTextPaint.setTextSize(this.mTextSize);
        this.invalidate();
    }

    public void setProgressTextColor(@ColorInt int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(this.mTextColor);
        this.invalidate();
    }

    public void setUnreachedBarColor(@ColorInt int barColor) {
        this.mUnreachedBarColor = barColor;
        this.mUnreachedBarPaint.setColor(this.mUnreachedBarColor);
        this.invalidate();
    }

    public void setReachedBarColor(@ColorInt int progressColor) {
        this.mReachedBarColor = progressColor;
        this.mReachedBarPaint.setColor(this.mReachedBarColor);
        this.invalidate();
    }

    public void setReachedBarHeight(float height) {
        this.mReachedBarHeight = height;
    }

    public void setUnreachedBarHeight(float height) {
        this.mUnreachedBarHeight = height;
    }

    public void setMax(int maxProgress) {
        if (maxProgress > 0) {
            this.mMaxProgress = this.validateProgress(maxProgress);
            this.invalidate();
        }
    }

    public void setSuffix(String suffix) {
        this.mSuffix = suffix == null ? "" : suffix;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix == null ? "" : prefix;
    }

    public void incrementProgressBy(int by) {
        if (by > 0) {
            this.setProgress(this.mCurrentProgress + by);
        }
        if (this.mListener != null) {
            this.mListener.onProgressChange(this.mCurrentProgress, this.mMaxProgress);
        }
    }

    public void setProgress(int progress) {
        if (progress <= this.mMaxProgress && progress >= 0) {
            this.mCurrentProgress = this.validateProgress(progress);
            this.invalidate();
        }
    }

    public void setNumberTextVisibility(@ProgressBarUtils.NumberVisibility int visibility) {
        this.mTextIsVisible = visibility == 0;
        this.invalidate();
    }

    public void setTimeMillis(long timeMillis) {
        this.timeMillis = timeMillis;
        this.invalidate();
    }

    public void setOnProgressBarListener(OnNumberProgressListener listener) {
        this.mListener = listener;
    }
}

