/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.edit.style;

import android.text.Editable;
import android.util.Pair;
import java.lang.reflect.ParameterizedType;

public abstract class NormalStyle<E> {
    private Class<E> clazzE = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public void applyStyle(Editable editable, int start, int end) {
        Object[] spans = editable.getSpans(start, end, this.clazzE);
        Object existingSpan = null;
        if (spans.length > 0) {
            existingSpan = spans[0];
        }
        if (existingSpan == null) {
            this.checkAndMergeSpan(editable, start, end, this.clazzE);
        } else {
            int existingSpanStart = editable.getSpanStart(existingSpan);
            int existingSpanEnd = editable.getSpanEnd(existingSpan);
            if (existingSpanStart <= start && existingSpanEnd >= end) {
                this.removeStyle(editable, start, end, this.clazzE, true);
            } else {
                this.checkAndMergeSpan(editable, start, end, this.clazzE);
            }
        }
    }

    private void removeStyle(Editable editable, int start, int end, Class<E> clazzE, boolean isSame) {
        Object[] spans = editable.getSpans(start, end, clazzE);
        if (spans.length > 0) {
            if (isSame) {
                Object span = spans[0];
                if (null != span) {
                    int ess = editable.getSpanStart(span);
                    int ese = editable.getSpanEnd(span);
                    if (start >= ese) {
                        editable.removeSpan(span);
                        editable.setSpan(span, ess, start - 1, 33);
                    } else if (start == ess && end == ese) {
                        editable.removeSpan(span);
                    } else if (start > ess && end < ese) {
                        editable.removeSpan(span);
                        E spanLeft = this.newSpan();
                        editable.setSpan(spanLeft, ess, start, 33);
                        E spanRight = this.newSpan();
                        editable.setSpan(spanRight, end, ese, 33);
                    } else if (start == ess && end < ese) {
                        editable.removeSpan(span);
                        E newSpan = this.newSpan();
                        editable.setSpan(newSpan, end, ese, 33);
                    } else if (start > ess && end == ese) {
                        editable.removeSpan(span);
                        E newSpan = this.newSpan();
                        editable.setSpan(newSpan, ess, start, 33);
                    }
                }
            } else {
                Pair<Object, Object> firstAndLast = this.findFirstAndLast(editable, spans);
                Object firstSpan = firstAndLast.first;
                Object lastSpan = firstAndLast.second;
                int leftStart = editable.getSpanStart(firstSpan);
                int rightEnd = editable.getSpanEnd(lastSpan);
                editable.removeSpan(firstSpan);
                editable.setSpan(firstSpan, leftStart, start, 34);
                editable.removeSpan(lastSpan);
                editable.setSpan(lastSpan, end, rightEnd, 33);
            }
        }
    }

    public Pair<E, E> findFirstAndLast(Editable editable, E[] targetSpans) {
        if (targetSpans != null && targetSpans.length > 0) {
            E firstTargetSpan = targetSpans[0];
            E lastTargetSpan = targetSpans[0];
            int firstTargetSpanStart = editable.getSpanStart(firstTargetSpan);
            int lastTargetSpanEnd = editable.getSpanEnd(firstTargetSpan);
            for (E lns : targetSpans) {
                int lnsStart = editable.getSpanStart(lns);
                int lnsEnd = editable.getSpanEnd(lns);
                if (lnsStart < firstTargetSpanStart) {
                    firstTargetSpan = lns;
                    firstTargetSpanStart = lnsStart;
                }
                if (lnsEnd <= lastTargetSpanEnd) continue;
                lastTargetSpan = lns;
                lastTargetSpanEnd = lnsEnd;
            }
            return new Pair(firstTargetSpan, lastTargetSpan);
        }
        return null;
    }

    private void checkAndMergeSpan(Editable editable, int start, int end, Class<E> clazzE) {
        Object leftSpan = null;
        Object[] leftSpans = editable.getSpans(start, start, clazzE);
        if (leftSpans.length > 0) {
            leftSpan = leftSpans[0];
        }
        Object rightSpan = null;
        Object[] rightSpans = editable.getSpans(end, end, clazzE);
        if (rightSpans.length > 0) {
            rightSpan = rightSpans[0];
        }
        int leftSpanStart = editable.getSpanStart(leftSpan);
        int leftSpanEnd = editable.getSpanEnd(leftSpan);
        int rightStart = editable.getSpanStart(rightSpan);
        int rightSpanEnd = editable.getSpanEnd(rightSpan);
        this.removeAllSpans(editable, start, end, clazzE);
        if (leftSpan != null && rightSpan != null) {
            if (leftSpanEnd == rightStart) {
                this.removeStyle(editable, start, end, clazzE, false);
            } else {
                E eSpan = this.newSpan();
                editable.setSpan(eSpan, leftSpanStart, rightSpanEnd, 33);
            }
        } else if (leftSpan != null && rightSpan == null) {
            E eSpan = this.newSpan();
            editable.setSpan(eSpan, leftSpanStart, end, 33);
        } else if (leftSpan == null && rightSpan != null) {
            E eSpan = this.newSpan();
            editable.setSpan(eSpan, start, rightSpanEnd, 33);
        } else {
            E eSpan = this.newSpan();
            editable.setSpan(eSpan, start, end, 33);
        }
    }

    protected abstract E newSpan();

    private <E> void removeAllSpans(Editable editable, int start, int end, Class<E> clazzE) {
        Object[] allSpans;
        for (Object span : allSpans = editable.getSpans(start, end, clazzE)) {
            editable.removeSpan(span);
        }
    }
}

