/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.edit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.ns.yc.yccustomtextlib.R;
import com.ns.yc.yccustomtextlib.edit.inter.OnHyperTextListener;
import com.ns.yc.yccustomtextlib.edit.manager.HyperManager;
import com.ns.yc.yccustomtextlib.edit.view.HyperImageView;
import com.ns.yc.yccustomtextlib.utils.HyperLibUtils;
import com.ns.yc.yccustomtextlib.utils.HyperLogUtils;
import java.util.ArrayList;

public class HyperTextView
extends ScrollView {
    private static final int EDIT_PADDING = 10;
    private int viewTagIndex = 1;
    private LinearLayout allLayout;
    private LayoutInflater inflater;
    private int editNormalPadding = 0;
    private View.OnClickListener btnListener;
    private ArrayList<String> imagePaths;
    private String keywords;
    private OnHyperTextListener onHyperTextListener;
    private int rtImageHeight = 0;
    private int rtImageBottom = 10;
    private String rtTextInitHint = "\u6ca1\u6709\u5185\u5bb9";
    private int rtTextSize = 16;
    private int rtTextColor = Color.parseColor((String)"#757575");
    private int rtTextLineSpace = 8;

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        HyperLogUtils.d("HyperTextView----onDetachedFromWindow------");
    }

    public HyperTextView(Context context) {
        this(context, null);
    }

    public HyperTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HyperTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.imagePaths = new ArrayList();
        this.inflater = LayoutInflater.from((Context)context);
        this.initAttrs(context, attrs);
        this.initLayoutView(context);
        this.initListener();
        this.initFirstTextView(context);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HyperTextView);
        this.rtImageHeight = ta.getInteger(R.styleable.HyperTextView_ht_view_image_height, 0);
        this.rtImageBottom = ta.getInteger(R.styleable.HyperTextView_ht_view_image_bottom, 10);
        this.rtTextSize = ta.getDimensionPixelSize(R.styleable.HyperTextView_ht_view_text_size, 16);
        this.rtTextLineSpace = ta.getDimensionPixelSize(R.styleable.HyperTextView_ht_view_text_line_space, 8);
        this.rtTextColor = ta.getColor(R.styleable.HyperTextView_ht_view_text_color, Color.parseColor((String)"#757575"));
        this.rtTextInitHint = ta.getString(R.styleable.HyperTextView_ht_view_text_init_hint);
        ta.recycle();
    }

    private void initLayoutView(Context context) {
        this.allLayout = new LinearLayout(context);
        this.allLayout.setOrientation(1);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.allLayout.setPadding(50, 15, 50, 15);
        this.addView((View)this.allLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initListener() {
        this.btnListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (v instanceof HyperImageView) {
                    HyperImageView imageView = (HyperImageView)v;
                    if (HyperTextView.this.onHyperTextListener != null) {
                        HyperTextView.this.onHyperTextListener.onImageClick((View)imageView, imageView.getAbsolutePath());
                    }
                }
            }
        };
    }

    private void initFirstTextView(Context context) {
        LinearLayout.LayoutParams firstEditParam = new LinearLayout.LayoutParams(-1, -1);
        int padding = HyperLibUtils.dip2px(context, 10.0f);
        TextView firstText = this.createTextView(this.rtTextInitHint, padding);
        this.allLayout.addView((View)firstText, (ViewGroup.LayoutParams)firstEditParam);
    }

    public void setOnHyperTextListener(OnHyperTextListener onRtImageClickListener) {
        this.onHyperTextListener = onRtImageClickListener;
    }

    public void clearAllLayout() {
        if (this.allLayout != null) {
            this.allLayout.removeAllViews();
        }
    }

    public int getLastIndex() {
        if (this.allLayout != null) {
            int lastEditIndex = this.allLayout.getChildCount();
            return lastEditIndex;
        }
        return -1;
    }

    public TextView createTextView(String hint, int paddingTop) {
        TextView textView = new TextView(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        textView.setTextSize(16.0f);
        textView.setTextColor(Color.parseColor((String)"#616161"));
        textView.setTextIsSelectable(true);
        textView.setBackground(null);
        textView.setTag((Object)this.viewTagIndex++);
        textView.setPadding(this.editNormalPadding, paddingTop, this.editNormalPadding, paddingTop);
        textView.setHint((CharSequence)hint);
        textView.setTextSize(0, (float)this.rtTextSize);
        textView.setLineSpacing((float)this.rtTextLineSpace, 1.0f);
        textView.setTextColor(this.rtTextColor);
        return textView;
    }

    private RelativeLayout createImageLayout() {
        RelativeLayout layout2 = (RelativeLayout)this.inflater.inflate(R.layout.edit_imageview, null);
        layout2.setTag((Object)this.viewTagIndex++);
        View closeView = layout2.findViewById(R.id.image_close);
        closeView.setVisibility(8);
        HyperImageView imageView = (HyperImageView)layout2.findViewById(R.id.edit_imageView);
        imageView.setOnClickListener(this.btnListener);
        return layout2;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void addTextViewAtIndex(int index, CharSequence editStr) {
        if (index == -1) {
            return;
        }
        try {
            TextView textView = this.createTextView("", 10);
            if (!TextUtils.isEmpty((CharSequence)this.keywords)) {
                SpannableStringBuilder textStr = HyperLibUtils.highlight(editStr.toString(), this.keywords, Color.parseColor((String)"#EE5C42"));
                textView.setText((CharSequence)textStr);
            } else {
                textView.setText(editStr);
            }
            this.allLayout.addView((View)textView, index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addImageViewAtIndex(int index, String imagePath) {
        if (index == -1) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return;
        }
        this.imagePaths.add(imagePath);
        RelativeLayout imageLayout = this.createImageLayout();
        if (imageLayout == null) {
            return;
        }
        HyperImageView imageView = (HyperImageView)imageLayout.findViewById(R.id.edit_imageView);
        imageView.setAbsolutePath(imagePath);
        HyperManager.getInstance().loadImage(imagePath, imageView, this.rtImageHeight);
        this.allLayout.addView((View)imageLayout, index);
    }

    public void addImageViewAtIndex(int index, String imagePath, boolean isWordWrap) {
        if (index == -1) {
            return;
        }
        if (imagePath == null || imagePath.length() == 0) {
            return;
        }
        Bitmap bmp = BitmapFactory.decodeFile((String)imagePath);
        RelativeLayout imageLayout = this.createImageLayout();
        HyperImageView imageView = (HyperImageView)imageLayout.findViewById(R.id.edit_imageView);
        imageView.setAbsolutePath(imagePath);
        int imageHeight = 500;
        if (bmp != null) {
            imageHeight = this.allLayout.getWidth() * bmp.getHeight() / bmp.getWidth();
            bmp.recycle();
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, imageHeight);
        lp.bottomMargin = 10;
        imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.allLayout.addView((View)imageLayout, index);
    }
}

