/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.labelEt;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.ns.yc.yccustomtextlib.R;

public class FloatLabeledEditText
extends FrameLayout {
    private static final int DEFAULT_PADDING_LEFT = 2;
    private TextView mHintTextView;
    private EditText mEditText;
    private Context mContext;

    public FloatLabeledEditText(Context context) {
        super(context);
        this.mContext = context;
    }

    public FloatLabeledEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setAttributes(attrs);
    }

    @TargetApi(value=11)
    public FloatLabeledEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.setAttributes(attrs);
    }

    private void setAttributes(AttributeSet attrs) {
        this.mHintTextView = new TextView(this.mContext);
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.LabeledEditText);
        int padding = a.getDimensionPixelSize(R.styleable.LabeledEditText_etPadding, 0);
        int defaultPadding = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int paddingLeft = a.getDimensionPixelSize(R.styleable.LabeledEditText_etPaddingLeft, defaultPadding);
        int paddingTop = a.getDimensionPixelSize(R.styleable.LabeledEditText_etPaddingTop, 0);
        int paddingRight = a.getDimensionPixelSize(R.styleable.LabeledEditText_etPaddingRight, 0);
        int paddingBottom = a.getDimensionPixelSize(R.styleable.LabeledEditText_etPaddingBottom, 0);
        Drawable background = a.getDrawable(R.styleable.LabeledEditText_etBackground);
        if (padding != 0) {
            this.mHintTextView.setPadding(padding, padding, padding, padding);
        } else {
            this.mHintTextView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        }
        if (background != null) {
            this.setHintBackground(background);
        }
        this.mHintTextView.setTextAppearance(this.mContext, a.getResourceId(R.styleable.LabeledEditText_etTextAppearance, 16973894));
        this.mHintTextView.setVisibility(4);
        this.addView((View)this.mHintTextView, -2, -2);
        a.recycle();
    }

    @SuppressLint(value={"NewApi"})
    private void setHintBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mHintTextView.setBackground(background);
        } else {
            this.mHintTextView.setBackgroundDrawable(background);
        }
    }

    public final void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof EditText) {
            if (this.mEditText != null) {
                throw new IllegalArgumentException("Can only have one Edittext subview");
            }
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(params);
            lp.gravity = 80;
            lp.topMargin = (int)(this.mHintTextView.getTextSize() + (float)this.mHintTextView.getPaddingBottom() + (float)this.mHintTextView.getPaddingTop());
            params = lp;
            this.setEditText((EditText)child);
        }
        super.addView(child, index, params);
    }

    private void setEditText(EditText editText) {
        this.mEditText = editText;
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                FloatLabeledEditText.this.setShowHint(!TextUtils.isEmpty((CharSequence)s));
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean gotFocus) {
                FloatLabeledEditText.this.onFocusChanged(gotFocus);
            }
        });
        this.mHintTextView.setText(this.mEditText.getHint());
        if (!TextUtils.isEmpty((CharSequence)this.mEditText.getText())) {
            this.mHintTextView.setVisibility(0);
        }
    }

    private void onFocusChanged(boolean gotFocus) {
        if (gotFocus && this.mHintTextView.getVisibility() == 0) {
            ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"alpha", (float[])new float[]{0.33f, 1.0f}).start();
        } else if (this.mHintTextView.getVisibility() == 0) {
            ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"alpha", (float[])new float[]{1.0f, 0.33f}).start();
        }
    }

    private void setShowHint(final boolean show) {
        AnimatorSet animation = null;
        if (this.mHintTextView.getVisibility() == 0 && !show) {
            animation = new AnimatorSet();
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"translationY", (float[])new float[]{0.0f, this.mHintTextView.getHeight() / 8});
            ObjectAnimator fade = ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            animation.playTogether(new Animator[]{move, fade});
        } else if (this.mHintTextView.getVisibility() != 0 && show) {
            animation = new AnimatorSet();
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"translationY", (float[])new float[]{this.mHintTextView.getHeight() / 8, 0.0f});
            ObjectAnimator fade = this.mEditText.isFocused() ? ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"alpha", (float[])new float[]{0.0f, 1.0f}) : ObjectAnimator.ofFloat((Object)this.mHintTextView, (String)"alpha", (float[])new float[]{0.0f, 0.33f});
            animation.playTogether(new Animator[]{move, fade});
        }
        if (animation != null) {
            animation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    FloatLabeledEditText.this.mHintTextView.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    FloatLabeledEditText.this.mHintTextView.setVisibility(show ? 0 : 4);
                }
            });
            animation.start();
        }
    }

    public EditText getEditText() {
        return this.mEditText;
    }

    public void setHint(String hint) {
        this.mEditText.setHint((CharSequence)hint);
        this.mHintTextView.setText((CharSequence)hint);
    }

    public CharSequence getHint() {
        return this.mHintTextView.getHint();
    }
}

