/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.gallery;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.yc.cn.ycbannerlib.gallery.GalleryLinearSnapHelper;
import com.yc.cn.ycbannerlib.gallery.GallerySmoothScroller;

public class GalleryLayoutManager
extends LinearLayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private static final String TAG = "GalleryLayoutManager";
    private static final int LAYOUT_START = -1;
    private static final int LAYOUT_END = 1;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private int mFirstVisiblePosition = 0;
    private int mLastVisiblePos = 0;
    private static int mCurSelectedPosition = 0;
    private State mState;
    private int mOrientation = 0;
    private OrientationHelper mHorizontalHelper;
    private OrientationHelper mVerticalHelper;
    private ItemTransformer mItemTransformer;

    public GalleryLayoutManager(Context context, int orientation) {
        super(context);
        this.mOrientation = orientation;
    }

    public void attach(int selectedPosition) {
        mCurSelectedPosition = Math.max(0, selectedPosition);
    }

    public void attach(RecyclerView recyclerView, int selectedPosition) {
        if (recyclerView == null) {
            throw new IllegalArgumentException("The attach RecycleView must not null!!");
        }
        GalleryLinearSnapHelper mSnapHelper = new GalleryLinearSnapHelper(recyclerView);
        mCurSelectedPosition = Math.max(0, selectedPosition);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this);
        mSnapHelper.attachToRecyclerView(recyclerView);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 1) {
            return new RecyclerView.LayoutParams(-1, -2);
        }
        return new RecyclerView.LayoutParams(-2, -1);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getItemCount() == 0) {
            this.reset();
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        if (state.isPreLayout() || state.getItemCount() != 0 && !state.didStructureChange()) {
            return;
        }
        if (this.getChildCount() == 0 || state.didStructureChange()) {
            this.reset();
        }
        int max = Math.max(0, mCurSelectedPosition);
        mCurSelectedPosition = Math.min(max, this.getItemCount() - 1);
        GalleryLayoutManager.logger("position+++++" + mCurSelectedPosition);
        this.detachAndScrapAttachedViews(recycler);
        this.firstFillCover(recycler, state, 0);
    }

    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        GallerySmoothScroller linearSmoothScroller = new GallerySmoothScroller(recyclerView.getContext());
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
        mCurSelectedPosition = position;
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        int direction = this.calculateScrollDirectionForPosition(targetPosition);
        PointF outVector = new PointF();
        if (direction == 0) {
            return null;
        }
        if (this.mOrientation == 0) {
            outVector.x = direction;
            outVector.y = 0.0f;
        } else {
            outVector.x = 0.0f;
            outVector.y = direction;
        }
        return outVector;
    }

    private void reset() {
        if (this.mState != null) {
            this.mState.mItemsFrames.clear();
        }
        this.mFirstVisiblePosition = mCurSelectedPosition = Math.min(Math.max(0, mCurSelectedPosition), this.getItemCount() - 1);
        this.mLastVisiblePos = mCurSelectedPosition;
    }

    private void firstFillCover(RecyclerView.Recycler recycler, RecyclerView.State state, int scrollDelta) {
        if (this.mOrientation == 0) {
            this.firstFillWithHorizontal(recycler, state);
        } else {
            this.firstFillWithVertical(recycler, state);
        }
        GalleryLayoutManager.logger("firstFillCover finish:first: " + this.mFirstVisiblePosition + ",last:" + this.mLastVisiblePos);
        if (this.mItemTransformer != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                this.mItemTransformer.transformItem(this, child, this.calculateToCenterFraction(child, scrollDelta));
            }
        }
    }

    private void firstFillWithHorizontal(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachAndScrapAttachedViews(recycler);
        int leftEdge = this.getOrientationHelper().getStartAfterPadding();
        int rightEdge = this.getOrientationHelper().getEndAfterPadding();
        int startPosition = mCurSelectedPosition;
        Rect scrapRect = new Rect();
        int height = this.getVerticalSpace();
        View scrap = recycler.getViewForPosition(mCurSelectedPosition);
        this.addView(scrap, 0);
        this.measureChildWithMargins(scrap, 0, 0);
        int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
        int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
        int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
        int left = (int)((float)this.getPaddingLeft() + (float)(this.getHorizontalSpace() - scrapWidth) / 2.0f);
        scrapRect.set(left, topOffset, left + scrapWidth, topOffset + scrapHeight);
        this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
        if (this.getState().mItemsFrames.get(startPosition) == null) {
            this.getState().mItemsFrames.put(startPosition, (Object)scrapRect);
        } else {
            ((Rect)this.getState().mItemsFrames.get(startPosition)).set(scrapRect);
        }
        this.mFirstVisiblePosition = this.mLastVisiblePos = startPosition;
        this.fillLeft(recycler, mCurSelectedPosition - 1, this.getDecoratedLeft(scrap), leftEdge);
        this.fillRight(recycler, mCurSelectedPosition + 1, this.getDecoratedRight(scrap), rightEdge);
    }

    private void firstFillWithVertical(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachAndScrapAttachedViews(recycler);
        int topEdge = this.getOrientationHelper().getStartAfterPadding();
        int bottomEdge = this.getOrientationHelper().getEndAfterPadding();
        int startPosition = mCurSelectedPosition;
        Rect scrapRect = new Rect();
        int width = this.getHorizontalSpace();
        View scrap = recycler.getViewForPosition(mCurSelectedPosition);
        this.addView(scrap, 0);
        this.measureChildWithMargins(scrap, 0, 0);
        int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
        int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
        int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
        int top = (int)((float)this.getPaddingTop() + (float)(this.getVerticalSpace() - scrapHeight) / 2.0f);
        scrapRect.set(leftOffset, top, leftOffset + scrapWidth, top + scrapHeight);
        this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
        if (this.getState().mItemsFrames.get(startPosition) == null) {
            this.getState().mItemsFrames.put(startPosition, (Object)scrapRect);
        } else {
            ((Rect)this.getState().mItemsFrames.get(startPosition)).set(scrapRect);
        }
        this.mFirstVisiblePosition = this.mLastVisiblePos = startPosition;
        this.fillTop(recycler, mCurSelectedPosition - 1, this.getDecoratedTop(scrap), topEdge);
        this.fillBottom(recycler, mCurSelectedPosition + 1, this.getDecoratedBottom(scrap), bottomEdge);
    }

    private void fillLeft(RecyclerView.Recycler recycler, int startPosition, int startOffset, int leftEdge) {
        Rect scrapRect = new Rect();
        int height = this.getVerticalSpace();
        for (int i = startPosition; i >= 0 && startOffset > leftEdge; --i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap, 0);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
            scrapRect.set(startOffset - scrapWidth, topOffset, startOffset, topOffset + scrapHeight);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.left;
            this.mFirstVisiblePosition = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillRight(RecyclerView.Recycler recycler, int startPosition, int startOffset, int rightEdge) {
        Rect scrapRect = new Rect();
        int height = this.getVerticalSpace();
        for (int i = startPosition; i < this.getItemCount() && startOffset < rightEdge; ++i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
            scrapRect.set(startOffset, topOffset, startOffset + scrapWidth, topOffset + scrapHeight);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.right;
            this.mLastVisiblePos = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillTop(RecyclerView.Recycler recycler, int startPosition, int startOffset, int topEdge) {
        Rect scrapRect = new Rect();
        int width = this.getHorizontalSpace();
        for (int i = startPosition; i >= 0 && startOffset > topEdge; --i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap, 0);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
            scrapRect.set(leftOffset, startOffset - scrapHeight, leftOffset + scrapWidth, startOffset);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.top;
            this.mFirstVisiblePosition = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillBottom(RecyclerView.Recycler recycler, int startPosition, int startOffset, int bottomEdge) {
        Rect scrapRect = new Rect();
        int width = this.getHorizontalSpace();
        for (int i = startPosition; i < this.getItemCount() && startOffset < bottomEdge; ++i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
            scrapRect.set(leftOffset, startOffset, leftOffset + scrapWidth, startOffset + scrapHeight);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.bottom;
            this.mLastVisiblePos = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillCover(RecyclerView.Recycler recycler, RecyclerView.State state, int scrollDelta) {
        if (this.getItemCount() == 0) {
            return;
        }
        if (this.mOrientation == 0) {
            this.fillWithHorizontal(recycler, state, scrollDelta);
        } else {
            this.fillWithVertical(recycler, state, scrollDelta);
        }
        if (this.mItemTransformer != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                this.mItemTransformer.transformItem(this, child, this.calculateToCenterFraction(child, scrollDelta));
            }
        }
    }

    private float calculateToCenterFraction(View child, float pendingOffset) {
        int distance = this.calculateDistanceCenter(child, pendingOffset);
        int childLength = this.mOrientation == 0 ? child.getWidth() : child.getHeight();
        GalleryLayoutManager.logger("calculateToCenterFraction: distance:" + distance + ",childLength:" + childLength);
        return Math.max(-1.0f, Math.min(1.0f, (float)distance * 1.0f / (float)childLength));
    }

    private int calculateDistanceCenter(View child, float pendingOffset) {
        OrientationHelper orientationHelper = this.getOrientationHelper();
        int parentCenter = (orientationHelper.getEndAfterPadding() - orientationHelper.getStartAfterPadding()) / 2 + orientationHelper.getStartAfterPadding();
        if (this.mOrientation == 0) {
            return (int)((float)(child.getWidth() / 2) - pendingOffset + (float)child.getLeft() - (float)parentCenter);
        }
        return (int)((float)(child.getHeight() / 2) - pendingOffset + (float)child.getTop() - (float)parentCenter);
    }

    private void fillWithVertical(RecyclerView.Recycler recycler, RecyclerView.State state, int dy) {
        GalleryLayoutManager.logger("fillWithVertical: dy:" + dy);
        int topEdge = this.getOrientationHelper().getStartAfterPadding();
        int bottomEdge = this.getOrientationHelper().getEndAfterPadding();
        if (this.getChildCount() > 0) {
            View child;
            if (dy >= 0) {
                int fixIndex = 0;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    child = this.getChildAt(i + fixIndex);
                    if (this.getDecoratedBottom(child) - dy < topEdge) {
                        GalleryLayoutManager.logger("fillWithVertical: removeAndRecycleView:" + this.getPosition(child) + ",bottom:" + this.getDecoratedBottom(child));
                        this.removeAndRecycleView(child, recycler);
                        ++this.mFirstVisiblePosition;
                        --fixIndex;
                        continue;
                    }
                    GalleryLayoutManager.logger("fillWithVertical: break:" + this.getPosition(child) + ",bottom:" + this.getDecoratedBottom(child));
                    break;
                }
            } else {
                for (int i = this.getChildCount() - 1; i >= 0 && this.getDecoratedTop(child = this.getChildAt(i)) - dy > bottomEdge; --i) {
                    GalleryLayoutManager.logger("fillWithVertical: removeAndRecycleView:" + this.getPosition(child));
                    this.removeAndRecycleView(child, recycler);
                    --this.mLastVisiblePos;
                }
            }
        }
        int startPosition = this.mFirstVisiblePosition;
        int startOffset = -1;
        int width = this.getHorizontalSpace();
        if (dy >= 0) {
            if (this.getChildCount() != 0) {
                View lastView = this.getChildAt(this.getChildCount() - 1);
                startPosition = this.getPosition(lastView) + 1;
                startOffset = this.getDecoratedBottom(lastView);
            }
            for (int i = startPosition; i < this.getItemCount() && startOffset < bottomEdge + dy; ++i) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
                if (startOffset == -1 && startPosition == 0) {
                    int top = (int)((float)this.getPaddingTop() + (float)(this.getVerticalSpace() - scrapHeight) / 2.0f);
                    scrapRect.set(leftOffset, top, leftOffset + scrapWidth, top + scrapHeight);
                } else {
                    scrapRect.set(leftOffset, startOffset, leftOffset + scrapWidth, startOffset + scrapHeight);
                }
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.bottom;
                this.mLastVisiblePos = i;
                GalleryLayoutManager.logger("fillWithVertical: add view:" + i + ",startOffset:" + startOffset + ",mLastVisiblePos:" + this.mLastVisiblePos + ",bottomEdge" + bottomEdge);
            }
        } else {
            if (this.getChildCount() > 0) {
                View firstView = this.getChildAt(0);
                startPosition = this.getPosition(firstView) - 1;
                startOffset = this.getDecoratedTop(firstView);
            }
            int i = startPosition;
            while (i >= 0 && startOffset > topEdge + dy) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap, 0);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
                scrapRect.set(leftOffset, startOffset - scrapHeight, leftOffset + scrapWidth, startOffset);
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.top;
                this.mFirstVisiblePosition = i--;
            }
        }
    }

    private void fillWithHorizontal(RecyclerView.Recycler recycler, RecyclerView.State state, int dx) {
        int leftEdge = this.getOrientationHelper().getStartAfterPadding();
        int rightEdge = this.getOrientationHelper().getEndAfterPadding();
        GalleryLayoutManager.logger("fillWithHorizontal() called with: dx = [" + dx + "],leftEdge:" + leftEdge + ",rightEdge:" + rightEdge);
        if (this.getChildCount() > 0) {
            View child;
            if (dx >= 0) {
                int fixIndex = 0;
                for (int i = 0; i < this.getChildCount() && this.getDecoratedRight(child = this.getChildAt(i + fixIndex)) - dx < leftEdge; ++i) {
                    this.removeAndRecycleView(child, recycler);
                    ++this.mFirstVisiblePosition;
                    --fixIndex;
                    GalleryLayoutManager.logger("fillWithHorizontal:removeAndRecycleView:" + this.getPosition(child) + " mFirstVisiblePosition change to:" + this.mFirstVisiblePosition);
                }
            } else {
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    child = this.getChildAt(i);
                    if (this.getDecoratedLeft(child) - dx <= rightEdge) continue;
                    this.removeAndRecycleView(child, recycler);
                    --this.mLastVisiblePos;
                    GalleryLayoutManager.logger("fillWithHorizontal:removeAndRecycleView:" + this.getPosition(child) + "mLastVisiblePos change to:" + this.mLastVisiblePos);
                }
            }
        }
        int startPosition = this.mFirstVisiblePosition;
        int startOffset = -1;
        int height = this.getVerticalSpace();
        if (dx >= 0) {
            if (this.getChildCount() != 0) {
                View lastView = this.getChildAt(this.getChildCount() - 1);
                startPosition = this.getPosition(lastView) + 1;
                startOffset = this.getDecoratedRight(lastView);
                GalleryLayoutManager.logger("fillWithHorizontal:to right startPosition:" + startPosition + ",startOffset:" + startOffset + ",rightEdge:" + rightEdge);
            }
            int i = startPosition;
            while (i < this.getItemCount() && startOffset < rightEdge + dx) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
                if (startOffset == -1 && startPosition == 0) {
                    int left = (int)((float)this.getPaddingLeft() + (float)(this.getHorizontalSpace() - scrapWidth) / 2.0f);
                    scrapRect.set(left, topOffset, left + scrapWidth, topOffset + scrapHeight);
                } else {
                    scrapRect.set(startOffset, topOffset, startOffset + scrapWidth, topOffset + scrapHeight);
                }
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.right;
                this.mLastVisiblePos = i++;
                GalleryLayoutManager.logger("fillWithHorizontal,layout:mLastVisiblePos: " + this.mLastVisiblePos);
            }
        } else {
            if (this.getChildCount() > 0) {
                View firstView = this.getChildAt(0);
                startPosition = this.getPosition(firstView) - 1;
                startOffset = this.getDecoratedLeft(firstView);
                GalleryLayoutManager.logger("fillWithHorizontal:to left startPosition:" + startPosition + ",startOffset:" + startOffset + ",leftEdge:" + leftEdge + ",child count:" + this.getChildCount());
            }
            int i = startPosition;
            while (i >= 0 && startOffset > leftEdge + dx) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap, 0);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
                scrapRect.set(startOffset - scrapWidth, topOffset, startOffset, topOffset + scrapHeight);
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.left;
                this.mFirstVisiblePosition = i--;
            }
        }
    }

    private int getHorizontalSpace() {
        return this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
    }

    private int getVerticalSpace() {
        return this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
    }

    private int calculateScrollDirectionForPosition(int position) {
        if (this.getChildCount() == 0) {
            return -1;
        }
        int firstChildPos = this.mFirstVisiblePosition;
        return position < firstChildPos ? -1 : 1;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dx == 0) {
            return 0;
        }
        int delta = -dx;
        int parentCenter = (this.getOrientationHelper().getEndAfterPadding() - this.getOrientationHelper().getStartAfterPadding()) / 2 + this.getOrientationHelper().getStartAfterPadding();
        if (dx > 0) {
            if (this.getPosition(this.getChildAt(this.getChildCount() - 1)) == this.getItemCount() - 1) {
                View child = this.getChildAt(this.getChildCount() - 1);
                delta = -Math.max(0, Math.min(dx, (child.getRight() - child.getLeft()) / 2 + child.getLeft() - parentCenter));
            }
        } else if (this.mFirstVisiblePosition == 0) {
            View child = this.getChildAt(0);
            delta = -Math.min(0, Math.max(dx, (child.getRight() - child.getLeft()) / 2 + child.getLeft() - parentCenter));
        }
        GalleryLayoutManager.logger("scrollHorizontallyBy: dx:" + dx + ",fixed:" + delta);
        this.getState().mScrollDelta = -delta;
        this.fillCover(recycler, state, -delta);
        this.offsetChildrenHorizontal(delta);
        return -delta;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        int delta = -dy;
        int parentCenter = (this.getOrientationHelper().getEndAfterPadding() - this.getOrientationHelper().getStartAfterPadding()) / 2 + this.getOrientationHelper().getStartAfterPadding();
        if (dy > 0) {
            if (this.getPosition(this.getChildAt(this.getChildCount() - 1)) == this.getItemCount() - 1) {
                View child = this.getChildAt(this.getChildCount() - 1);
                delta = -Math.max(0, Math.min(dy, (this.getDecoratedBottom(child) - this.getDecoratedTop(child)) / 2 + this.getDecoratedTop(child) - parentCenter));
            }
        } else if (this.mFirstVisiblePosition == 0) {
            View child = this.getChildAt(0);
            delta = -Math.min(0, Math.max(dy, (this.getDecoratedBottom(child) - this.getDecoratedTop(child)) / 2 + this.getDecoratedTop(child) - parentCenter));
        }
        GalleryLayoutManager.logger("scrollVerticallyBy: dy:" + dy + ",fixed:" + delta);
        this.getState().mScrollDelta = -delta;
        this.fillCover(recycler, state, -delta);
        this.offsetChildrenVertical(delta);
        return -delta;
    }

    private OrientationHelper getOrientationHelper() {
        if (this.mOrientation == 0) {
            if (this.mHorizontalHelper == null) {
                this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this);
            }
            return this.mHorizontalHelper;
        }
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this);
        }
        return this.mVerticalHelper;
    }

    public void setItemTransformer(ItemTransformer itemTransformer) {
        this.mItemTransformer = itemTransformer;
    }

    private State getState() {
        if (this.mState == null) {
            this.mState = new State();
        }
        return this.mState;
    }

    static int getPosition() {
        GalleryLayoutManager.logger("position-----" + mCurSelectedPosition);
        return mCurSelectedPosition;
    }

    static void setPosition(int position) {
        mCurSelectedPosition = position;
    }

    private static void logger(String log) {
    }

    class State {
        SparseArray<Rect> mItemsFrames = new SparseArray();
        int mScrollDelta = 0;

        State() {
        }
    }

    public static interface ItemTransformer {
        public void transformItem(GalleryLayoutManager var1, View var2, float var3);
    }
}

