/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.banner;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.yc.cn.ycbannerlib.LibUtils;
import com.yc.cn.ycbannerlib.R;
import com.yc.cn.ycbannerlib.banner.adapter.AbsLoopPagerAdapter;
import com.yc.cn.ycbannerlib.banner.hintview.ColorPointHintView;
import com.yc.cn.ycbannerlib.banner.hintview.TextHintView;
import com.yc.cn.ycbannerlib.banner.inter.BaseHintView;
import com.yc.cn.ycbannerlib.banner.inter.HintViewDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;

public class BannerView
extends RelativeLayout {
    private ViewPager mViewPager;
    private PagerAdapter mAdapter;
    private GestureDetector mGestureDetector;
    private long mRecentTouchTime;
    private int hintMode;
    private int delay;
    private int gravity;
    private int color;
    private int alpha;
    private int paddingLeft;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;
    private View mHintView;
    private Timer timer;
    private HintViewDelegate mHintViewDelegate = new HintViewDelegate(){

        @Override
        public void setCurrentPosition(int position, BaseHintView hintView) {
            if (hintView != null) {
                hintView.setCurrent(position);
            }
        }

        @Override
        public void initView(int length, int gravity, BaseHintView hintView) {
            if (hintView != null) {
                hintView.initView(length, gravity);
            }
        }
    };
    private TimeTaskHandler mHandler = new TimeTaskHandler(this);
    private OnPageListener mOnPageListener;
    private OnBannerClickListener mOnItemClickListener;

    public BannerView(Context context) {
        this(context, null);
    }

    public BannerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        if (this.mViewPager != null) {
            this.removeView((View)this.mViewPager);
        }
        TypedArray type = this.getContext().obtainStyledAttributes(attrs, R.styleable.BannerView);
        this.hintMode = type.getInteger(R.styleable.BannerView_hint_mode, 0);
        this.gravity = type.getInteger(R.styleable.BannerView_hint_gravity, 1);
        this.delay = type.getInt(R.styleable.BannerView_play_delay, 0);
        this.color = type.getColor(R.styleable.BannerView_hint_color, -16777216);
        this.alpha = type.getInt(R.styleable.BannerView_hint_alpha, 0);
        this.paddingLeft = (int)type.getDimension(R.styleable.BannerView_hint_paddingLeft, 0.0f);
        this.paddingRight = (int)type.getDimension(R.styleable.BannerView_hint_paddingRight, 0.0f);
        this.paddingTop = (int)type.getDimension(R.styleable.BannerView_hint_paddingTop, 0.0f);
        this.paddingBottom = (int)type.getDimension(R.styleable.BannerView_hint_paddingBottom, (float)LibUtils.dip2px(this.getContext(), 4.0f));
        this.mViewPager = new ViewPager(this.getContext());
        this.mViewPager.setId(R.id.banner_inner);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView((View)this.mViewPager);
        type.recycle();
        if (this.hintMode == 0) {
            this.initHint(new ColorPointHintView(this.getContext(), Color.parseColor((String)"#E3AC42"), Color.parseColor((String)"#88ffffff")));
        } else if (this.hintMode == 1) {
            this.initHint(new TextHintView(this.getContext()));
        } else {
            this.initHint(new ColorPointHintView(this.getContext(), Color.parseColor((String)"#E3AC42"), Color.parseColor((String)"#88ffffff")));
        }
        this.initGestureDetector();
    }

    private void initGestureDetector() {
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                if (BannerView.this.mOnItemClickListener != null) {
                    if (BannerView.this.mAdapter instanceof AbsLoopPagerAdapter) {
                        int i = BannerView.this.mViewPager.getCurrentItem() % ((AbsLoopPagerAdapter)BannerView.this.mAdapter).getRealCount();
                        BannerView.this.mOnItemClickListener.onItemClick(i);
                    } else {
                        BannerView.this.mOnItemClickListener.onItemClick(BannerView.this.mViewPager.getCurrentItem());
                    }
                }
                return super.onSingleTapUp(e);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        View childView = this.getChildAt(0);
        int cWidth = childView.getMeasuredWidth();
        int cHeight = childView.getMeasuredHeight();
        ViewGroup.MarginLayoutParams cParams = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
        cParams.setMargins(0, 0, 0, 0);
        int width = widthMode == 0x40000000 ? cWidth : -1;
        int height = heightMode == 0x40000000 ? cHeight : LibUtils.dip2px(this.getContext(), 200.0f);
        this.setMeasuredDimension(width, height);
    }

    private void startPlay() {
        if (this.delay <= 0 || this.mAdapter == null || this.mAdapter.getCount() <= 1) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new WeakTimerTask(this), this.delay, (long)this.delay);
    }

    private void stopPlay() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void setHintViewDelegate(HintViewDelegate delegate) {
        this.mHintViewDelegate = delegate;
    }

    private void initHint(BaseHintView hintView) {
        if (this.mHintView != null) {
            this.removeView(this.mHintView);
        }
        if (hintView == null) {
            return;
        }
        this.mHintView = (View)hintView;
        this.loadHintView();
    }

    private void loadHintView() {
        this.addView(this.mHintView);
        this.mHintView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        lp.addRule(12);
        this.mHintView.setLayoutParams((ViewGroup.LayoutParams)lp);
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(this.color);
        gd.setAlpha(this.alpha);
        this.mHintView.setBackgroundDrawable((Drawable)gd);
        this.mHintViewDelegate.initView(this.mAdapter == null ? 0 : this.mAdapter.getCount(), this.gravity, (BaseHintView)this.mHintView);
    }

    @TargetApi(value=19)
    public void setAnimationDuration(final int during) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            Interpolator interpolator = new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            };
            Scroller mScroller = new Scroller(this.getContext(), interpolator){

                public void startScroll(int startX, int startY, int dx, int dy, int duration) {
                    duration = System.currentTimeMillis() - BannerView.this.mRecentTouchTime > (long)BannerView.this.delay ? during : (duration /= 2);
                    super.startScroll(startX, startY, dx, dy, duration);
                }

                public void startScroll(int startX, int startY, int dx, int dy) {
                    super.startScroll(startX, startY, dx, dy, during);
                }
            };
            mField.set(this.mViewPager, mScroller);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void pause() {
        this.stopPlay();
    }

    public void resume() {
        this.startPlay();
    }

    public boolean isPlaying() {
        return this.timer != null;
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setAdapter(PagerAdapter adapter) {
        adapter.registerDataSetObserver((DataSetObserver)new PagerObserver());
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position >= 0) {
                    BannerView.this.mHintViewDelegate.setCurrentPosition(position, (BaseHintView)BannerView.this.mHintView);
                    if (BannerView.this.mOnPageListener != null) {
                        BannerView.this.mOnPageListener.onPageChange(position);
                    }
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mAdapter = adapter;
        this.dataSetChanged();
    }

    private void dataSetChanged() {
        if (this.mHintView != null) {
            this.mHintViewDelegate.initView(this.mAdapter.getCount(), this.gravity, (BaseHintView)this.mHintView);
            this.mHintViewDelegate.setCurrentPosition(this.mViewPager.getCurrentItem(), (BaseHintView)this.mHintView);
        }
        this.startPlay();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        this.mGestureDetector.onTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    public void setPlayDelay(int delay) {
        this.delay = delay;
        this.startPlay();
    }

    public void setHintColor(@ColorInt int c) {
        this.color = c;
        this.mHintView.setBackgroundColor(c);
    }

    public void setHintGravity(int g) {
        this.gravity = g;
        this.mHintViewDelegate.initView(this.mAdapter == null ? 0 : this.mAdapter.getCount(), this.gravity, (BaseHintView)this.mHintView);
    }

    public void setHintMode(int mode) {
        this.hintMode = mode;
    }

    public void setHintPadding(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.mHintView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
    }

    public void setHintAlpha(int alpha) {
        this.alpha = alpha;
        this.initHint((BaseHintView)this.mHintView);
    }

    public void setHintView(BaseHintView hintView) {
        if (this.mHintView != null) {
            this.removeView(this.mHintView);
        }
        this.mHintView = (View)hintView;
        if (hintView != null) {
            this.initHint(hintView);
        }
    }

    public void setOnPageListener(OnPageListener listener) {
        this.mOnPageListener = listener;
    }

    public void setOnBannerClickListener(OnBannerClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public static interface OnBannerClickListener {
        public void onItemClick(int var1);
    }

    public static interface OnPageListener {
        public void onPageChange(int var1);
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            BannerView.this.dataSetChanged();
        }

        public void onInvalidated() {
            BannerView.this.dataSetChanged();
        }
    }

    private static class WeakTimerTask
    extends TimerTask {
        private WeakReference<BannerView> mRollPagerView;

        WeakTimerTask(BannerView mRollPagerView) {
            this.mRollPagerView = new WeakReference<BannerView>(mRollPagerView);
        }

        @Override
        public void run() {
            BannerView rollPagerView = (BannerView)((Object)this.mRollPagerView.get());
            if (rollPagerView != null) {
                if (rollPagerView.isShown() && System.currentTimeMillis() - rollPagerView.mRecentTouchTime > (long)rollPagerView.delay) {
                    rollPagerView.mHandler.sendEmptyMessage(0);
                }
            } else {
                this.cancel();
            }
        }
    }

    private static final class TimeTaskHandler
    extends Handler {
        private WeakReference<BannerView> mRollPagerView;

        TimeTaskHandler(BannerView rollPagerView) {
            this.mRollPagerView = new WeakReference<BannerView>(rollPagerView);
        }

        public void handleMessage(Message msg) {
            BannerView rollPagerView = (BannerView)((Object)this.mRollPagerView.get());
            if (rollPagerView != null) {
                int cur = rollPagerView.getViewPager().getCurrentItem() + 1;
                if (cur >= rollPagerView.mAdapter.getCount()) {
                    cur = 0;
                }
                rollPagerView.getViewPager().setCurrentItem(cur);
                rollPagerView.mHintViewDelegate.setCurrentPosition(cur, (BaseHintView)rollPagerView.mHintView);
                if (rollPagerView.mAdapter.getCount() <= 1) {
                    rollPagerView.stopPlay();
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HintMode {
        public static final int COLOR_POINT_HINT = 0;
        public static final int TEXT_HINT = 1;
    }
}

