/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.adapter;

import android.annotation.TargetApi;
import android.database.DataSetObserver;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import com.yc.cn.ycbannerlib.BannerView;
import com.yc.cn.ycbannerlib.inter.BaseHintView;
import com.yc.cn.ycbannerlib.inter.HintViewDelegate;
import java.lang.reflect.Field;
import java.util.ArrayList;

public abstract class AbsLoopPagerAdapter
extends PagerAdapter {
    private BannerView mViewPager;
    private ArrayList<View> mViewList = new ArrayList();

    public void notifyDataSetChanged() {
        this.mViewList.clear();
        this.initPosition();
        super.notifyDataSetChanged();
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        super.registerDataSetObserver(observer);
        this.initPosition();
    }

    private void initPosition() {
        if (this.mViewPager.getViewPager().getCurrentItem() == 0 && this.getRealCount() > 0) {
            int half = 0x3FFFFFFF;
            int start = half - half % this.getRealCount();
            this.setCurrent(start);
        }
    }

    @TargetApi(value=19)
    private void setCurrent(int index) {
        try {
            Field field = ViewPager.class.getDeclaredField("mCurItem");
            field.setAccessible(true);
            field.set(this.mViewPager.getViewPager(), index);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public AbsLoopPagerAdapter(BannerView viewPager) {
        this.mViewPager = viewPager;
        viewPager.setHintViewDelegate(new LoopHintViewDelegate());
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == arg1;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int realPosition = position % this.getRealCount();
        View itemView = this.findViewByPosition(container, realPosition);
        container.addView(itemView);
        return itemView;
    }

    private View findViewByPosition(ViewGroup container, int position) {
        for (View view : this.mViewList) {
            if ((Integer)view.getTag() != position || view.getParent() != null) continue;
            return view;
        }
        View view = this.getView(container, position);
        view.setTag((Object)position);
        this.mViewList.add(view);
        return view;
    }

    public abstract View getView(ViewGroup var1, int var2);

    @Deprecated
    public final int getCount() {
        return this.getRealCount() <= 0 ? this.getRealCount() : Integer.MAX_VALUE;
    }

    public abstract int getRealCount();

    private class LoopHintViewDelegate
    implements HintViewDelegate {
        private LoopHintViewDelegate() {
        }

        @Override
        public void setCurrentPosition(int position, BaseHintView hintView) {
            if (hintView != null && AbsLoopPagerAdapter.this.getRealCount() > 0) {
                hintView.setCurrent(position % AbsLoopPagerAdapter.this.getRealCount());
            }
        }

        @Override
        public void initView(int length, int gravity, BaseHintView hintView) {
            if (hintView != null) {
                hintView.initView(AbsLoopPagerAdapter.this.getRealCount(), gravity);
            }
        }
    }
}

