/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.marquee;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import android.widget.ViewFlipper;
import com.yc.cn.ycbannerlib.R;
import java.util.ArrayList;

public class MarqueeView
extends ViewFlipper {
    private Context mContext;
    private ArrayList<String> notices;
    private boolean isSetAnimDuration = false;
    private OnItemClickListener onItemClickListener;
    private int interval = 2000;
    private int animDuration = 500;
    private int textSize = 14;
    private int textColor = -1;
    private boolean singleLine = false;
    private int gravity = 8388627;
    private static final int TEXT_GRAVITY_LEFT = 0;
    private static final int TEXT_GRAVITY_CENTER = 1;
    private static final int TEXT_GRAVITY_RIGHT = 2;

    public MarqueeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mContext = context;
        if (this.notices == null) {
            this.notices = new ArrayList();
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.MarqueeViewStyle, defStyleAttr, 0);
        this.interval = typedArray.getInteger(R.styleable.MarqueeViewStyle_mvInterval, this.interval);
        this.isSetAnimDuration = typedArray.hasValue(R.styleable.MarqueeViewStyle_mvAnimDuration);
        this.singleLine = typedArray.getBoolean(R.styleable.MarqueeViewStyle_mvSingleLine, false);
        this.animDuration = typedArray.getInteger(R.styleable.MarqueeViewStyle_mvAnimDuration, this.animDuration);
        if (typedArray.hasValue(R.styleable.MarqueeViewStyle_mvTextSize)) {
            this.textSize = (int)typedArray.getDimension(R.styleable.MarqueeViewStyle_mvTextSize, (float)this.textSize);
            this.textSize = MarqueeView.px2sp(this.mContext, this.textSize);
        }
        this.textColor = typedArray.getColor(R.styleable.MarqueeViewStyle_mvTextColor, this.textColor);
        int gravityType = typedArray.getInt(R.styleable.MarqueeViewStyle_mvGravity, 0);
        switch (gravityType) {
            case 1: {
                this.gravity = 17;
                break;
            }
            case 2: {
                this.gravity = 8388627;
                break;
            }
        }
        typedArray.recycle();
        this.setFlipInterval(this.interval);
    }

    public void startWithText(final String notice) {
        if (TextUtils.isEmpty((CharSequence)notice)) {
            return;
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MarqueeView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                MarqueeView.this.startWithFixedWidth(notice, MarqueeView.this.getWidth());
            }
        });
    }

    public void startWithList(ArrayList<String> notices) {
        this.setNotices(notices);
        this.start();
    }

    private void startWithFixedWidth(String notice, int width) {
        int noticeLength = notice.length();
        int dpW = MarqueeView.px2dip(this.mContext, width);
        int limit = dpW / this.textSize;
        if (dpW == 0) {
            throw new RuntimeException("Please set MarqueeView width !");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (noticeLength <= limit) {
            list.add(notice);
        } else {
            int size = noticeLength / limit + (noticeLength % limit != 0 ? 1 : 0);
            for (int i = 0; i < size; ++i) {
                int startIndex = i * limit;
                int endIndex = (i + 1) * limit >= noticeLength ? noticeLength : (i + 1) * limit;
                list.add(notice.substring(startIndex, endIndex));
            }
        }
        this.notices.addAll(list);
        this.start();
    }

    public boolean start() {
        if (this.notices == null || this.notices.size() == 0) {
            return false;
        }
        this.removeAllViews();
        this.resetAnimation();
        int i = 0;
        while (i < this.notices.size()) {
            final TextView textView = this.createTextView(this.notices.get(i), i);
            final int finalI = i++;
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MarqueeView.this.onItemClickListener != null) {
                        MarqueeView.this.onItemClickListener.onItemClick(finalI, textView);
                    }
                }
            });
            this.addView((View)textView);
        }
        if (this.notices.size() > 1) {
            this.startFlipping();
        } else {
            this.stopFlipping();
        }
        return true;
    }

    private void resetAnimation() {
        this.clearAnimation();
        Animation animIn = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_marquee_in);
        if (this.isSetAnimDuration) {
            animIn.setDuration((long)this.animDuration);
        }
        this.setInAnimation(animIn);
        Animation animOut = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_marquee_out);
        if (this.isSetAnimDuration) {
            animOut.setDuration((long)this.animDuration);
        }
        this.setOutAnimation(animOut);
    }

    private TextView createTextView(CharSequence text, int position) {
        TextView tv = new TextView(this.mContext);
        tv.setGravity(this.gravity);
        tv.setText(text);
        tv.setTextColor(this.textColor);
        tv.setTextSize((float)this.textSize);
        tv.setSingleLine(this.singleLine);
        tv.setTag((Object)position);
        return tv;
    }

    public int getPosition() {
        return (Integer)this.getCurrentView().getTag();
    }

    public ArrayList<String> getNotices() {
        return this.notices;
    }

    public void setNotices(ArrayList<String> notices) {
        this.notices = notices;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int px2dip(Context ctx, float pxValue) {
        float scale = ctx.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, TextView var2);
    }
}

