/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.gallery;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.yc.cn.ycbannerlib.gallery.GalleryLayoutManager;
import com.yc.cn.ycbannerlib.gallery.GalleryLinearSnapHelper;
import com.yc.cn.ycbannerlib.gallery.GalleryScaleTransformer;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

public class GalleryRecyclerView
extends RecyclerView {
    private int delay;
    private long mRecentTouchTime;
    private Timer timer;
    private int size;
    private int mFlingSpeed = 1000;
    private RecyclerView.Adapter adapter;
    private boolean mCallbackInFling = false;
    private static int mSelectedPosition;
    private LinearSnapHelper mSnapHelper;
    private TimeTaskHandler mHandler = new TimeTaskHandler(this);
    private OnItemSelectedListener mOnItemSelectedListener;

    public GalleryRecyclerView(Context context) {
        this(context, null);
    }

    public GalleryRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GalleryRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        this.smoothScrollToPosition(0);
        this.smoothScrollBy(10, 0);
        this.smoothScrollBy(0, 0);
        this.startPlay();
    }

    public boolean fling(int velocityX, int velocityY) {
        velocityX = this.balanceVelocity(velocityX);
        velocityY = this.balanceVelocity(velocityY);
        return super.fling(velocityX, velocityY);
    }

    private int balanceVelocity(int velocity) {
        if (velocity > 0) {
            return Math.min(velocity, this.mFlingSpeed);
        }
        return Math.max(velocity, -this.mFlingSpeed);
    }

    private void startPlay() {
        if (this.delay <= 0 || this.size <= 1) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new WeakTimerTask(this), this.delay, (long)this.delay);
    }

    private void stopPlay() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void onStop() {
        this.stopPlay();
    }

    public void onStart() {
        this.startPlay();
    }

    public boolean isPlaying() {
        return this.timer != null;
    }

    public void release() {
        this.stopPlay();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.clearOnScrollListeners();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        int action = ev.getAction();
        if (action == 1 || action == 3 || action == 4) {
            this.startPlay();
        } else if (action == 0) {
            mSelectedPosition = this.getCurrentItem() + 2;
            Log.e((String)"handleMessage----", (String)("----" + mSelectedPosition));
            this.stopPlay();
        }
        return super.dispatchTouchEvent(ev);
    }

    public GalleryRecyclerView setFlingSpeed(@IntRange(from=0L) int speed) {
        this.mFlingSpeed = speed;
        return this;
    }

    public GalleryRecyclerView setDataAdapter(RecyclerView.Adapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public GalleryRecyclerView setDelayTime(@IntRange(from=0L) int interval) {
        this.delay = interval;
        return this;
    }

    public GalleryRecyclerView setSize(@IntRange(from=0L) int size) {
        this.size = size;
        return this;
    }

    public GalleryRecyclerView setCallbackInFling(boolean callbackInFling) {
        this.mCallbackInFling = callbackInFling;
        return this;
    }

    public GalleryRecyclerView setSelectedPosition(int position) {
        mSelectedPosition = position;
        return this;
    }

    public GalleryRecyclerView setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
        return this;
    }

    public void setUp() {
        this.setAdapter(this.adapter);
        if (this.getAdapter().getItemCount() <= 0) {
            return;
        }
        GalleryLayoutManager manager = new GalleryLayoutManager(0);
        manager.attach(mSelectedPosition);
        manager.setItemTransformer(new GalleryScaleTransformer(0.2f));
        this.setLayoutManager(manager);
        this.mSnapHelper = new GalleryLinearSnapHelper(this);
        this.mSnapHelper.attachToRecyclerView((RecyclerView)this);
        this.addOnScrollListener(new InnerScrollListener());
        this.startPlay();
    }

    public int getCurrentItem() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (this.mSnapHelper != null) {
            View snapView = this.mSnapHelper.findSnapView(layoutManager);
            if (snapView != null) {
                return layoutManager.getPosition(snapView);
            }
            return mSelectedPosition;
        }
        return mSelectedPosition;
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(RecyclerView var1, View var2, int var3);
    }

    private class InnerScrollListener
    extends RecyclerView.OnScrollListener {
        int mState;
        boolean mCallbackOnIdle;

        private InnerScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int selectedPosition;
            super.onScrolled(recyclerView, dx, dy);
            View snap = GalleryRecyclerView.this.mSnapHelper.findSnapView(recyclerView.getLayoutManager());
            if (snap != null && (selectedPosition = recyclerView.getLayoutManager().getPosition(snap)) != GalleryLayoutManager.getPosition()) {
                GalleryLayoutManager.setPosition(selectedPosition);
                if (!GalleryRecyclerView.this.mCallbackInFling && this.mState != 0) {
                    this.mCallbackOnIdle = true;
                    return;
                }
                if (GalleryRecyclerView.this.mOnItemSelectedListener != null) {
                    GalleryRecyclerView.this.mOnItemSelectedListener.onItemSelected(recyclerView, snap, GalleryLayoutManager.getPosition());
                }
            }
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            View snap;
            super.onScrollStateChanged(recyclerView, newState);
            this.mState = newState;
            if (this.mState == 0 && (snap = GalleryRecyclerView.this.mSnapHelper.findSnapView(recyclerView.getLayoutManager())) != null) {
                int selectedPosition = recyclerView.getLayoutManager().getPosition(snap);
                if (selectedPosition != GalleryLayoutManager.getPosition()) {
                    GalleryLayoutManager.setPosition(selectedPosition);
                    if (GalleryRecyclerView.this.mOnItemSelectedListener != null) {
                        GalleryRecyclerView.this.mOnItemSelectedListener.onItemSelected(recyclerView, snap, GalleryLayoutManager.getPosition());
                    }
                } else if (!GalleryRecyclerView.this.mCallbackInFling && GalleryRecyclerView.this.mOnItemSelectedListener != null && this.mCallbackOnIdle) {
                    this.mCallbackOnIdle = false;
                    GalleryRecyclerView.this.mOnItemSelectedListener.onItemSelected(recyclerView, snap, GalleryLayoutManager.getPosition());
                }
            }
        }
    }

    private static class WeakTimerTask
    extends TimerTask {
        private WeakReference<GalleryRecyclerView> mGalleryRecyclerView;

        WeakTimerTask(GalleryRecyclerView recyclerView) {
            this.mGalleryRecyclerView = new WeakReference<GalleryRecyclerView>(recyclerView);
        }

        @Override
        public void run() {
            GalleryRecyclerView recyclerView = (GalleryRecyclerView)((Object)this.mGalleryRecyclerView.get());
            if (recyclerView != null) {
                if (recyclerView.isShown() && System.currentTimeMillis() - recyclerView.mRecentTouchTime > (long)recyclerView.delay) {
                    recyclerView.mHandler.sendEmptyMessage(0);
                }
            } else {
                this.cancel();
            }
        }
    }

    private static final class TimeTaskHandler
    extends Handler {
        private WeakReference<GalleryRecyclerView> mGalleryRecyclerView;

        TimeTaskHandler(GalleryRecyclerView rollPagerView) {
            this.mGalleryRecyclerView = new WeakReference<GalleryRecyclerView>(rollPagerView);
        }

        public void handleMessage(Message msg) {
            GalleryRecyclerView recyclerView = (GalleryRecyclerView)((Object)this.mGalleryRecyclerView.get());
            if (recyclerView != null) {
                int cur = mSelectedPosition++;
                int currentItem = recyclerView.getCurrentItem();
                Log.e((String)"handleMessage----", (String)(cur + "----" + currentItem));
                recyclerView.smoothScrollToPosition(cur);
                if (recyclerView.size <= 1) {
                    recyclerView.stopPlay();
                }
            }
        }
    }
}

