/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.first.hintview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yc.cn.ycbannerlib.first.hintview.BaseHintView;

public abstract class ShapeHintView
extends LinearLayout
implements BaseHintView {
    private ImageView[] mDots;
    private int length = 0;
    private int lastPosition = 0;
    private Drawable dot_normal;
    private Drawable dot_focus;

    public ShapeHintView(Context context) {
        super(context);
    }

    public ShapeHintView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public abstract Drawable makeFocusDrawable();

    public abstract Drawable makeNormalDrawable();

    @Override
    public void initView(int length, int gravity) {
        this.removeAllViews();
        this.lastPosition = 0;
        this.setOrientation(0);
        switch (gravity) {
            case 0: {
                this.setGravity(19);
                break;
            }
            case 1: {
                this.setGravity(17);
                break;
            }
            case 2: {
                this.setGravity(21);
            }
        }
        this.length = length;
        this.mDots = new ImageView[length];
        this.dot_focus = this.makeFocusDrawable();
        this.dot_normal = this.makeNormalDrawable();
        for (int i = 0; i < length; ++i) {
            this.mDots[i] = new ImageView(this.getContext());
            LinearLayout.LayoutParams dotlp = new LinearLayout.LayoutParams(-2, -2);
            dotlp.setMargins(10, 0, 10, 0);
            this.mDots[i].setLayoutParams((ViewGroup.LayoutParams)dotlp);
            this.mDots[i].setBackgroundDrawable(this.dot_normal);
            this.addView((View)this.mDots[i]);
        }
        this.setCurrent(0);
    }

    @Override
    public void setCurrent(int current) {
        if (current < 0 || current > this.length - 1) {
            return;
        }
        this.mDots[this.lastPosition].setBackgroundDrawable(this.dot_normal);
        this.mDots[current].setBackgroundDrawable(this.dot_focus);
        this.lastPosition = current;
    }
}

