/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.first.hintview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import com.yc.cn.ycbannerlib.first.hintview.ShapeHintView;
import com.yc.cn.ycbannerlib.first.util.SizeUtil;

public class IconHintView
extends ShapeHintView {
    private int focusResId;
    private int normalResId;
    private int size;

    public IconHintView(Context context, @DrawableRes int focusResId, @DrawableRes int normalResId) {
        this(context, focusResId, normalResId, SizeUtil.dip2px(context, 32.0f));
    }

    public IconHintView(Context context, @DrawableRes int focusResId, @DrawableRes int normalResId, int size) {
        super(context);
        this.focusResId = focusResId;
        this.normalResId = normalResId;
        this.size = size;
    }

    @Override
    public Drawable makeFocusDrawable() {
        Drawable drawable = this.getContext().getResources().getDrawable(this.focusResId);
        if (this.size > 0) {
            drawable = this.zoomDrawable(drawable, this.size, this.size);
        }
        return drawable;
    }

    @Override
    public Drawable makeNormalDrawable() {
        Drawable drawable = this.getContext().getResources().getDrawable(this.normalResId);
        if (this.size > 0) {
            drawable = this.zoomDrawable(drawable, this.size, this.size);
        }
        return drawable;
    }

    private Drawable zoomDrawable(Drawable drawable, int w, int h) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap oldBmp = this.drawableToBitmap(drawable);
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBmp = Bitmap.createBitmap((Bitmap)oldBmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return new BitmapDrawable(null, newBmp);
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        return bitmap;
    }
}

