/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videoview;

import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class SmallWindowTouch
implements View.OnTouchListener {
    private int mDownX;
    private int mDownY;
    private int mMarginLeft;
    private int mMarginTop;
    private int _xDelta;
    private int _yDelta;
    private View mView;

    public SmallWindowTouch(View view, int marginLeft, int marginTop) {
        this.mMarginLeft = marginLeft;
        this.mMarginTop = marginTop;
        this.mView = view;
    }

    public boolean onTouch(View view, MotionEvent event) {
        int X = (int)event.getRawX();
        int Y = (int)event.getRawY();
        Log.e((String)"onTouch", (String)("---X---" + X + "---Y---" + Y));
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mDownX = X;
                this.mDownY = Y;
                FrameLayout.LayoutParams lParams = (FrameLayout.LayoutParams)this.mView.getLayoutParams();
                this._xDelta = X - lParams.leftMargin;
                this._yDelta = Y - lParams.topMargin;
                break;
            }
            case 1: {
                return Math.abs(this.mDownY - Y) >= 5 || Math.abs(this.mDownX - X) >= 5;
            }
            case 2: {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mView.getLayoutParams();
                layoutParams.leftMargin = X - this._xDelta;
                layoutParams.topMargin = Y - this._yDelta;
                if (layoutParams.leftMargin >= this.mMarginLeft) {
                    layoutParams.leftMargin = this.mMarginLeft;
                }
                if (layoutParams.topMargin >= this.mMarginTop) {
                    layoutParams.topMargin = this.mMarginTop;
                }
                if (layoutParams.leftMargin <= 0) {
                    layoutParams.leftMargin = 0;
                }
                if (layoutParams.topMargin <= 0) {
                    layoutParams.topMargin = 0;
                }
                this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                break;
            }
        }
        return false;
    }
}

