/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videoview;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import com.yc.videoview.WindowUtil;
import java.util.ArrayList;
import java.util.List;

public class PermissionActivity
extends AppCompatActivity {
    private static List<PermissionListener> mPermissionListenerList;
    private static PermissionListener mPermissionListener;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestAlertWindowPermission();
        }
    }

    @RequiresApi(api=23)
    private void requestAlertWindowPermission() {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivityForResult(intent, 1);
    }

    @RequiresApi(api=23)
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (Build.VERSION.SDK_INT >= 23) {
            if (WindowUtil.hasPermission((Context)this)) {
                mPermissionListener.onSuccess();
            } else {
                mPermissionListener.onFail();
            }
        }
        this.finish();
    }

    static synchronized void request(Context context, PermissionListener permissionListener) {
        if (mPermissionListenerList == null) {
            mPermissionListenerList = new ArrayList<PermissionListener>();
            mPermissionListener = new PermissionListener(){

                @Override
                public void onSuccess() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        listener.onSuccess();
                    }
                }

                @Override
                public void onFail() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        listener.onFail();
                    }
                }
            };
            Intent intent = new Intent(context, PermissionActivity.class);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        mPermissionListenerList.add(permissionListener);
    }

    public static interface PermissionListener {
        public void onSuccess();

        public void onFail();
    }
}

