/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videoview;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.yc.videoview.FloatView;
import com.yc.videoview.PermissionActivity;
import com.yc.videoview.WindowUtil;

public class FloatPhone
extends FloatView {
    private final Context mContext;
    private final WindowManager mWindowManager;
    private final WindowManager.LayoutParams mLayoutParams;
    private View mView;
    private int mX;
    private int mY;

    FloatPhone(Context applicationContext) {
        this.mContext = applicationContext;
        this.mWindowManager = (WindowManager)applicationContext.getSystemService("window");
        this.mLayoutParams = new WindowManager.LayoutParams();
    }

    @Override
    public void setSize(int width, int height) {
        this.mLayoutParams.width = width;
        this.mLayoutParams.height = height;
    }

    @Override
    public void setView(View view) {
        int layoutType = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        this.mLayoutParams.flags = 40;
        this.mLayoutParams.type = layoutType;
        this.mLayoutParams.windowAnimations = 0;
        this.mView = view;
    }

    @Override
    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.mLayoutParams.gravity = gravity;
        this.mLayoutParams.x = this.mX = xOffset;
        this.mLayoutParams.y = this.mY = yOffset;
    }

    @Override
    public void init() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (WindowUtil.hasPermission(this.mContext)) {
                this.mLayoutParams.format = 1;
                this.mWindowManager.addView(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
            } else {
                PermissionActivity.request(this.mContext, new PermissionActivity.PermissionListener(){

                    @Override
                    public void onSuccess() {
                        ((FloatPhone)FloatPhone.this).mLayoutParams.format = 1;
                        FloatPhone.this.mWindowManager.addView(FloatPhone.this.mView, (ViewGroup.LayoutParams)FloatPhone.this.mLayoutParams);
                    }

                    @Override
                    public void onFail() {
                    }
                });
            }
        }
    }

    @Override
    public void dismiss() {
        this.mWindowManager.removeView(this.mView);
    }

    @Override
    public void updateXY(int x, int y) {
        this.mLayoutParams.x = this.mX = x;
        this.mLayoutParams.y = this.mY = y;
        this.mWindowManager.updateViewLayout(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    @Override
    void updateX(int x) {
        this.mLayoutParams.x = this.mX = x;
        this.mWindowManager.updateViewLayout(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    @Override
    void updateY(int y) {
        this.mLayoutParams.y = this.mY = y;
        this.mWindowManager.updateViewLayout(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    @Override
    int getX() {
        return this.mX;
    }

    @Override
    int getY() {
        return this.mY;
    }
}

