/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videoview;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.RequiresApi;
import com.yc.videoview.LifecycleListener;

@RequiresApi(api=14)
class FloatLifecycle
extends BroadcastReceiver
implements Application.ActivityLifecycleCallbacks {
    private static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    private static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    private static final long delay = 300L;
    private Handler mHandler;
    private Class[] activities;
    private boolean showFlag;
    private int startCount;
    private int resumeCount;
    private boolean appBackground;
    private LifecycleListener mLifecycleListener;

    FloatLifecycle(Context applicationContext, boolean showFlag, Class[] activities, LifecycleListener lifecycleListener) {
        this.showFlag = showFlag;
        this.activities = activities;
        this.mLifecycleListener = lifecycleListener;
        this.mHandler = new Handler();
        ((Application)applicationContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        applicationContext.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }

    private boolean needShow(Activity activity) {
        if (this.activities == null) {
            return true;
        }
        for (Class a : this.activities) {
            if (!a.isInstance(activity)) continue;
            return this.showFlag;
        }
        return !this.showFlag;
    }

    public void onActivityResumed(Activity activity) {
        ++this.resumeCount;
        if (this.needShow(activity)) {
            this.mLifecycleListener.onShow();
        }
        if (this.appBackground) {
            this.appBackground = false;
        }
    }

    public void onActivityPaused(Activity activity) {
        --this.resumeCount;
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (FloatLifecycle.this.resumeCount == 0) {
                    FloatLifecycle.this.appBackground = true;
                }
            }
        }, 300L);
    }

    public void onActivityStarted(Activity activity) {
        ++this.startCount;
    }

    public void onActivityStopped(Activity activity) {
        --this.startCount;
        if (this.startCount == 0) {
            // empty if block
        }
    }

    public void onReceive(Context context, Intent intent) {
        String reason;
        String action = intent.getAction();
        if (action == null || !action.equals("android.intent.action.CLOSE_SYSTEM_DIALOGS") || SYSTEM_DIALOG_REASON_HOME_KEY.equals(reason = intent.getStringExtra(SYSTEM_DIALOG_REASON_KEY))) {
            // empty if block
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

