/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.model;

import android.os.Build;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoLocation
implements Serializable {
    private String url;
    private String urlMd5;
    private long position;
    private long totalTime;

    public VideoLocation() {
    }

    public VideoLocation(String url, long position, long totalTime) {
        this.url = url;
        this.position = position;
        this.totalTime = totalTime;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlMd5() {
        return this.urlMd5;
    }

    public void setUrlMd5(String urlMd5) {
        this.urlMd5 = urlMd5;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("url", (Object)this.getUrl());
            jsonObject.put("urlMd5", (Object)this.getUrlMd5());
            jsonObject.put("position", this.getPosition());
            jsonObject.put("totalTime", this.getTotalTime());
            return jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static VideoLocation toObject(String jsonStr) {
        VideoLocation m = new VideoLocation();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            m.setUrl(jsonObject.has("url") ? jsonObject.getString("url") : null);
            m.setUrlMd5(jsonObject.has("urlMd5") ? jsonObject.getString("urlMd5") : null);
            m.setPosition(jsonObject.has("position") ? jsonObject.getLong("position") : 0L);
            m.setTotalTime(jsonObject.has("totalTime") ? jsonObject.getLong("totalTime") : 0L);
            return m;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return m;
        }
    }

    public String toString() {
        return "VideoLocation{url='" + this.url + '\'' + ", urlMd5='" + this.urlMd5 + '\'' + ", position=" + this.position + ", totalTime=" + this.totalTime + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoLocation location = (VideoLocation)o;
        if (Build.VERSION.SDK_INT >= 19) {
            return this.position == location.position && this.totalTime == location.totalTime && Objects.equals(this.url, location.url) && Objects.equals(this.urlMd5, location.urlMd5);
        }
        return this.position == location.position && this.totalTime == location.totalTime && this.equals(this.url, location.url) && this.equals(this.urlMd5, location.urlMd5);
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.hash(this.url, this.urlMd5, this.position, this.totalTime);
        }
        return this.hash(this.url, this.urlMd5, this.position, this.totalTime);
    }

    private boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private int hash(Object ... values) {
        return Arrays.hashCode(values);
    }
}

