/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.model;

import com.yc.videosqllite.cache.VideoLruCache;
import com.yc.videosqllite.manager.CacheConfig;
import com.yc.videosqllite.manager.LocationManager;
import com.yc.videosqllite.utils.CacheLogUtils;
import com.yc.videosqllite.utils.VideoMd5Utils;

public class SafeKeyGenerator {
    private final VideoLruCache<Integer, String> loadIdToSafeHash = new VideoLruCache(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSafeKey(String url) {
        String safeKey;
        if (url == null || url.length() == 0) {
            return null;
        }
        int hashCode = url.hashCode();
        VideoLruCache<Integer, String> videoLruCache = this.loadIdToSafeHash;
        synchronized (videoLruCache) {
            safeKey = this.loadIdToSafeHash.get(hashCode);
            CacheLogUtils.d("SafeKeyGenerator-----\u83b7\u53d6\u7f13\u5b58key-" + safeKey);
        }
        if (safeKey == null || safeKey.length() == 0) {
            CacheConfig cacheConfig = LocationManager.getInstance().getCacheConfig();
            safeKey = VideoMd5Utils.encryptMD5ToString(url, cacheConfig.getSalt());
            CacheLogUtils.d("SafeKeyGenerator-----md5\u8f6c\u5316key-" + safeKey);
        }
        videoLruCache = this.loadIdToSafeHash;
        synchronized (videoLruCache) {
            this.loadIdToSafeHash.put(hashCode, safeKey);
            CacheLogUtils.d("SafeKeyGenerator-----\u5b58\u50a8key-" + safeKey);
        }
        return safeKey;
    }
}

