/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.manager;

import android.content.Context;
import android.os.Debug;
import com.yc.videosqllite.cache.VideoMapCache;
import com.yc.videosqllite.disk.DiskFileUtils;
import com.yc.videosqllite.disk.SqlLiteCache;
import com.yc.videosqllite.manager.CacheConfig;
import com.yc.videosqllite.model.VideoLocation;
import com.yc.videosqllite.utils.CacheLogUtils;
import java.io.IOException;

public class LocationManager {
    private VideoMapCache videoMapCache;
    private SqlLiteCache sqlLiteCache;
    private CacheConfig cacheConfig;

    public static LocationManager getInstance() {
        return ManagerHolder.INSTANCE;
    }

    public void init(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        CacheLogUtils.setIsLog(cacheConfig.isLog());
        this.videoMapCache = new VideoMapCache();
        this.sqlLiteCache = new SqlLiteCache();
        CacheLogUtils.d("LocationManager-----init\u521d\u59cb\u5316-");
    }

    public CacheConfig getCacheConfig() {
        if (this.cacheConfig == null) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
        return this.cacheConfig;
    }

    public synchronized void put(String url, VideoLocation location) {
        if (!this.cacheConfig.isEffective()) {
            return;
        }
        if (url == null || url.length() == 0 || location == null) {
            return;
        }
        long currentTimeMillis1 = System.currentTimeMillis();
        if (this.cacheConfig.getType() == 1) {
            this.sqlLiteCache.put(url, location);
        } else if (this.cacheConfig.getType() == 2) {
            this.videoMapCache.put(url, location);
            this.sqlLiteCache.put(url, location);
        } else if (this.cacheConfig.getType() == 0) {
            this.videoMapCache.put(url, location);
        } else {
            this.videoMapCache.put(url, location);
        }
        long currentTimeMillis2 = System.currentTimeMillis();
        CacheLogUtils.d("LocationManager-----put--\u5b58\u6570\u636e\u8017\u65f6-" + (currentTimeMillis2 - currentTimeMillis1));
    }

    public synchronized long get(String url) {
        long position;
        if (!this.cacheConfig.isEffective()) {
            return 0L;
        }
        if (url == null || url.length() == 0) {
            return 0L;
        }
        long currentTimeMillis1 = System.currentTimeMillis();
        if (this.cacheConfig.getType() == 1) {
            position = this.sqlLiteCache.get(url);
        } else if (this.cacheConfig.getType() == 2) {
            position = this.videoMapCache.get(url);
            if (position < 0L) {
                position = this.sqlLiteCache.get(url);
            }
        } else {
            position = this.cacheConfig.getType() == 0 ? this.videoMapCache.get(url) : this.videoMapCache.get(url);
        }
        long currentTimeMillis2 = System.currentTimeMillis();
        CacheLogUtils.d("LocationManager-----get--\u53d6\u6570\u636e\u8017\u65f6-" + (currentTimeMillis2 - currentTimeMillis1) + "---\u8fdb\u5ea6-" + position);
        return position;
    }

    public synchronized boolean remove(String url) {
        if (!this.cacheConfig.isEffective()) {
            return false;
        }
        if (url == null || url.length() == 0) {
            return false;
        }
        if (this.cacheConfig.getType() == 1) {
            return this.sqlLiteCache.remove(url);
        }
        if (this.cacheConfig.getType() == 2) {
            boolean remove = this.videoMapCache.remove(url);
            boolean removeSql = this.sqlLiteCache.remove(url);
            return remove || removeSql;
        }
        if (this.cacheConfig.getType() == 0) {
            return this.videoMapCache.remove(url);
        }
        return this.videoMapCache.remove(url);
    }

    public synchronized boolean containsKey(String url) {
        boolean containsKey;
        if (!this.cacheConfig.isEffective()) {
            return false;
        }
        if (url == null || url.length() == 0) {
            return false;
        }
        if (this.cacheConfig.getType() == 1) {
            containsKey = this.sqlLiteCache.containsKey(url);
        } else if (this.cacheConfig.getType() == 2) {
            containsKey = this.videoMapCache.containsKey(url);
            if (!containsKey) {
                containsKey = this.sqlLiteCache.containsKey(url);
                return containsKey;
            }
        } else {
            containsKey = this.cacheConfig.getType() == 0 ? this.videoMapCache.containsKey(url) : this.videoMapCache.containsKey(url);
        }
        return containsKey;
    }

    public synchronized void clearAll() {
        if (!this.cacheConfig.isEffective()) {
            return;
        }
        if (this.cacheConfig.getType() == 1) {
            this.sqlLiteCache.clearAll();
        } else if (this.cacheConfig.getType() == 2) {
            this.videoMapCache.clearAll();
            this.sqlLiteCache.clearAll();
        } else if (this.cacheConfig.getType() == 0) {
            this.videoMapCache.clearAll();
        } else {
            this.videoMapCache.clearAll();
        }
    }

    public long getUseMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        CacheLogUtils.d("LocationManager-----\u5185\u5b58-" + totalMemory + "-----" + freeMemory);
        long useMemory = totalMemory - freeMemory;
        CacheLogUtils.d("LocationManager-----\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u4f7f\u7528\u7684\u5185\u5b58-" + useMemory);
        return useMemory;
    }

    public long setMemoryThreshold(int proportion) {
        if (proportion < 0 || proportion > 10) {
            proportion = 2;
        }
        long totalMemory = Runtime.getRuntime().totalMemory();
        long threshold = totalMemory / (long)proportion;
        CacheLogUtils.d("LocationManager-----\u8bbe\u5b9a\u5185\u5b58\u7684\u9608\u503c-" + threshold);
        return threshold;
    }

    public void dumpHprofData(Context context) {
        String dump = DiskFileUtils.getPath(context, "dump");
        CacheLogUtils.d("LocationManager-----\u83b7\u53d6Java\u5185\u5b58\u5feb\u7167\u6587\u4ef6-" + dump);
        try {
            Debug.dumpHprofData((String)dump);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ManagerHolder {
        private static final LocationManager INSTANCE = new LocationManager();

        private ManagerHolder() {
        }
    }
}

