/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.disk;

import com.yc.videosqllite.disk.DiskFileUtils;
import com.yc.videosqllite.disk.DiskLruCacheWrapper;
import com.yc.videosqllite.disk.InterDiskCache;
import com.yc.videosqllite.manager.CacheConfig;
import com.yc.videosqllite.manager.LocationManager;
import com.yc.videosqllite.model.SafeKeyGenerator;
import com.yc.videosqllite.model.VideoLocation;
import com.yc.videosqllite.utils.CacheLogUtils;
import java.io.File;

public class SqlLiteCache {
    private InterDiskCache interDiskCache;
    public final SafeKeyGenerator safeKeyGenerator;

    public SqlLiteCache() {
        CacheConfig cacheConfig = LocationManager.getInstance().getCacheConfig();
        File path = DiskFileUtils.getFilePath(cacheConfig.getContext());
        String pathString = path.getPath();
        CacheLogUtils.d("SqlLiteCache-----pathString\u8def\u5f84\u8f93\u51fa\u5730\u5740-" + pathString);
        this.safeKeyGenerator = new SafeKeyGenerator();
        this.interDiskCache = DiskLruCacheWrapper.get(path, this.safeKeyGenerator);
    }

    public synchronized void put(String url, VideoLocation location) {
        if (location == null) {
            return;
        }
        String safeKey = this.safeKeyGenerator.getSafeKey(url);
        location.setUrlMd5(safeKey);
        String json = location.toJson();
        CacheLogUtils.d("SqlLiteCache-----put--json--" + json);
        this.interDiskCache.put(url, json);
    }

    public synchronized long get(String url) {
        String data = this.interDiskCache.get(url);
        if (data == null || data.length() == 0) {
            return -1L;
        }
        CacheLogUtils.d("SqlLiteCache-----get---" + data);
        VideoLocation location = VideoLocation.toObject(data);
        return location.getPosition();
    }

    public synchronized boolean remove(String url) {
        return this.interDiskCache.remove(url);
    }

    public synchronized boolean containsKey(String url) {
        return this.interDiskCache.containsKey(url);
    }

    public synchronized void clearAll() {
        this.interDiskCache.clear();
    }
}

