/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.disk;

import android.content.Context;
import androidx.annotation.Nullable;
import com.yc.videosqllite.disk.DiskLruCacheFactory;
import java.io.File;

public final class ExternalDiskCacheFactory
extends DiskLruCacheFactory {
    public ExternalDiskCacheFactory(Context context) {
        this(context, "disk", 0xFA00000L);
    }

    public ExternalDiskCacheFactory(Context context, long diskCacheSize) {
        this(context, "disk", diskCacheSize);
    }

    public ExternalDiskCacheFactory(final Context context, final String diskCacheName, long diskCacheSize) {
        super(new DiskLruCacheFactory.CacheDirectoryGetter(){

            @Nullable
            private File getInternalCacheDirectory() {
                File cacheDirectory = context.getCacheDir();
                if (cacheDirectory == null) {
                    return null;
                }
                if (diskCacheName != null) {
                    return new File(cacheDirectory, diskCacheName);
                }
                return cacheDirectory;
            }

            @Override
            public File getCacheDirectory() {
                File internalCacheDirectory = this.getInternalCacheDirectory();
                if (null != internalCacheDirectory && internalCacheDirectory.exists()) {
                    return internalCacheDirectory;
                }
                File cacheDirectory = context.getExternalCacheDir();
                if (cacheDirectory == null || !cacheDirectory.canWrite()) {
                    return internalCacheDirectory;
                }
                if (diskCacheName != null) {
                    return new File(cacheDirectory, diskCacheName);
                }
                return cacheDirectory;
            }
        }, diskCacheSize);
    }
}

