/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.disk;

import androidx.annotation.Nullable;
import com.yc.videosqllite.disk.DiskCacheWriteLocker;
import com.yc.videosqllite.disk.DiskLruCache;
import com.yc.videosqllite.disk.InterDiskCache;
import com.yc.videosqllite.manager.CacheConfig;
import com.yc.videosqllite.manager.LocationManager;
import com.yc.videosqllite.model.SafeKeyGenerator;
import com.yc.videosqllite.utils.CacheLogUtils;
import java.io.File;
import java.io.IOException;

public class DiskLruCacheWrapper
implements InterDiskCache {
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static DiskLruCacheWrapper wrapper;
    public final SafeKeyGenerator safeKeyGenerator;
    private final File directory;
    private final long maxSize;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();
    private DiskLruCache diskLruCache;

    public static synchronized InterDiskCache get(File directory, SafeKeyGenerator safeKeyGenerator) {
        if (wrapper == null) {
            wrapper = new DiskLruCacheWrapper(directory, safeKeyGenerator);
        }
        return wrapper;
    }

    public static InterDiskCache create(File directory, SafeKeyGenerator safeKeyGenerator) {
        return new DiskLruCacheWrapper(directory, safeKeyGenerator);
    }

    @Deprecated
    protected DiskLruCacheWrapper(File directory, SafeKeyGenerator safeKeyGenerator) {
        CacheConfig cacheConfig = LocationManager.getInstance().getCacheConfig();
        this.directory = directory;
        this.safeKeyGenerator = safeKeyGenerator;
        this.maxSize = cacheConfig.getCacheMax();
    }

    private synchronized DiskLruCache getDiskCache() throws IOException {
        if (this.diskLruCache == null) {
            this.diskLruCache = DiskLruCache.open(this.directory, 1, 1, this.maxSize);
        }
        return this.diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String get(String key) {
        String safeKey = this.safeKeyGenerator.getSafeKey(key);
        String result = null;
        try {
            DiskLruCache.Value value = this.getDiskCache().get(safeKey);
            if (value != null) {
                result = value.getString(0);
            }
        }
        catch (IOException e) {
            CacheLogUtils.d("DiskLruCacheWrapper-----Unable to get from disk cache-" + e);
        }
        finally {
            try {
                this.getDiskCache().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String data) {
        String safeKey = this.safeKeyGenerator.getSafeKey(key);
        this.writeLocker.acquire(safeKey);
        try {
            CacheLogUtils.d("DiskLruCacheWrapper-----Put: Obtained:" + safeKey + " for for Key: " + key);
            try {
                DiskLruCache diskCache = this.getDiskCache();
                DiskLruCache.Value current = diskCache.get(safeKey);
                if (current != null) {
                    return;
                }
                DiskLruCache.Editor editor = diskCache.edit(safeKey);
                if (editor == null) {
                    throw new IllegalStateException("Had two simultaneous puts for: " + safeKey);
                }
                try {
                    editor.set(0, data);
                    editor.commit();
                }
                finally {
                    editor.abortUnlessCommitted();
                }
            }
            catch (IOException e) {
                CacheLogUtils.d("DiskLruCacheWrapper-----Unable to put from disk cache-" + e);
            }
            finally {
                try {
                    this.getDiskCache().flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.writeLocker.release(safeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        boolean isRemove;
        String safeKey = this.safeKeyGenerator.getSafeKey(key);
        try {
            isRemove = this.getDiskCache().remove(safeKey);
        }
        catch (IOException e) {
            CacheLogUtils.d("DiskLruCacheWrapper-----Unable to delete from disk cache-" + e);
            isRemove = false;
        }
        finally {
            try {
                this.getDiskCache().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return isRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        String safeKey = this.safeKeyGenerator.getSafeKey(key);
        boolean result = false;
        try {
            String string;
            DiskLruCache.Value value = this.getDiskCache().get(safeKey);
            if (value != null && (string = value.getString(0)) != null && string.length() > 0) {
                result = true;
            }
        }
        catch (IOException e) {
            CacheLogUtils.d("DiskLruCacheWrapper-----Unable to get from disk cache-" + e);
        }
        finally {
            try {
                this.getDiskCache().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void clear() {
        try {
            this.getDiskCache().delete();
        }
        catch (IOException e) {
            CacheLogUtils.d("DiskLruCacheWrapper-----Unable to clear disk cache or disk cache cleared externally-" + e);
        }
        finally {
            try {
                this.getDiskCache().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.resetDiskCache();
        }
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }
}

