/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.disk;

import com.yc.videosqllite.disk.DiskLruCacheWrapper;
import com.yc.videosqllite.disk.InterDiskCache;
import com.yc.videosqllite.disk.InterDiskFactory;
import com.yc.videosqllite.model.SafeKeyGenerator;
import java.io.File;

public class DiskLruCacheFactory
implements InterDiskFactory {
    private final long diskCacheSize;
    private final CacheDirectoryGetter cacheDirectoryGetter;

    public DiskLruCacheFactory(final String diskCacheFolder, long diskCacheSize) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(diskCacheFolder);
            }
        }, diskCacheSize);
    }

    public DiskLruCacheFactory(final String diskCacheFolder, final String diskCacheName, long diskCacheSize) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(diskCacheFolder, diskCacheName);
            }
        }, diskCacheSize);
    }

    public DiskLruCacheFactory(CacheDirectoryGetter cacheDirectoryGetter, long diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
        this.cacheDirectoryGetter = cacheDirectoryGetter;
    }

    @Override
    public InterDiskCache build() {
        File cacheDir = this.cacheDirectoryGetter.getCacheDirectory();
        if (cacheDir == null) {
            return null;
        }
        if (!(cacheDir.mkdirs() || cacheDir.exists() && cacheDir.isDirectory())) {
            return null;
        }
        return DiskLruCacheWrapper.create(cacheDir, new SafeKeyGenerator());
    }

    public static interface CacheDirectoryGetter {
        public File getCacheDirectory();
    }
}

