/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.disk;

import android.content.Context;
import android.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class DiskFileUtils {
    public static String getPath(Context context) {
        String path = DiskFileUtils.getCachePath(context) + File.separator + "disk";
        return path;
    }

    public static String getPath(Context context, String pathName) {
        String path = DiskFileUtils.getCachePath(context) + File.separator + pathName;
        return path;
    }

    public static File getFilePath(Context context) {
        String path = DiskFileUtils.getPath(context);
        File file = new File(path);
        return file;
    }

    public static String getCachePath(Context context) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? (context.getExternalCacheDir() != null ? context.getExternalCacheDir().getAbsolutePath() : context.getCacheDir().getAbsolutePath()) : context.getCacheDir().getAbsolutePath();
        return cachePath;
    }

    public static List<File> getFileList(Context context) {
        File file = new File(DiskFileUtils.getPath(context));
        ArrayList<File> mFileList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length <= 0) {
            return mFileList;
        }
        for (File f : fileArray) {
            if (!f.isFile()) continue;
            mFileList.add(f);
        }
        return mFileList;
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static void deleteAllFiles(File root) {
        File[] files = root.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    DiskFileUtils.deleteAllFiles(f);
                    try {
                        f.delete();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!f.exists()) continue;
                DiskFileUtils.deleteAllFiles(f);
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String readFile2String(String fileName) {
        String res = "";
        try {
            FileInputStream inputStream = new FileInputStream(fileName);
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader((InputStream)inputStream, "utf-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            BufferedReader reader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder("");
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            res = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static void renameFile(String oldPath, String newPath) {
        File oleFile = new File(oldPath);
        File newFile = new File(newPath);
        oleFile.renameTo(newFile);
    }

    public static boolean copyFile(File src, File dest) {
        boolean result = false;
        if (src == null || dest == null) {
            return result;
        }
        if (dest.exists()) {
            dest.delete();
        }
        if (!DiskFileUtils.createOrExistsDir(dest.getParentFile())) {
            return false;
        }
        try {
            dest.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileChannel srcChannel = null;
        FileChannel dstChannel = null;
        try {
            srcChannel = new FileInputStream(src).getChannel();
            dstChannel = new FileOutputStream(dest).getChannel();
            srcChannel.transferTo(0L, srcChannel.size(), dstChannel);
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return result;
        }
        try {
            srcChannel.close();
            dstChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }
}

