/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videosqllite.cache;

import com.yc.videosqllite.cache.InterCache;
import com.yc.videosqllite.cache.VideoLruCache;
import com.yc.videosqllite.model.SafeKeyGenerator;
import com.yc.videosqllite.model.VideoLocation;

public class VideoMapCache {
    private InterCache<String, VideoLocation> mCache = new VideoLruCache<String, VideoLocation>(1000);
    private final SafeKeyGenerator safeKeyGenerator = new SafeKeyGenerator();

    public synchronized void put(String url, VideoLocation location) {
        if (url == null || url.length() == 0) {
            return;
        }
        if (location == null) {
            return;
        }
        String safeKey = this.safeKeyGenerator.getSafeKey(url);
        location.setUrlMd5(safeKey);
        this.mCache.put(safeKey, location);
    }

    public synchronized long get(String url) {
        if (url == null || url.length() == 0) {
            return -1L;
        }
        String key = this.safeKeyGenerator.getSafeKey(url);
        VideoLocation videoLocation = this.mCache.get(key);
        if (videoLocation == null) {
            return -1L;
        }
        if (videoLocation.getTotalTime() <= videoLocation.getPosition()) {
            return -1L;
        }
        long position = videoLocation.getPosition();
        if (position < 0L) {
            position = -1L;
        }
        return position;
    }

    public synchronized boolean remove(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        String key = this.safeKeyGenerator.getSafeKey(url);
        VideoLocation location = this.mCache.remove(key);
        return location != null;
    }

    public synchronized boolean containsKey(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        String key = this.safeKeyGenerator.getSafeKey(url);
        return this.mCache.containsKey(key);
    }

    public synchronized boolean clearAll() {
        this.mCache.clear();
        int size = this.mCache.size();
        return size == 0;
    }
}

