/*
 * Decompiled with CFR 0.152.
 */
package com.yc.m3u8.utils;

import android.util.Log;
import com.yc.m3u8.bean.M3u8;
import com.yc.m3u8.bean.M3u8Ts;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class M3u8FileUtils {
    public static M3u8 parseIndex(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        if (conn.getResponseCode() == 200) {
            String line;
            String realUrl = conn.getURL().toString();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String basepath = realUrl.substring(0, realUrl.lastIndexOf("/") + 1);
            M3u8 ret = new M3u8();
            ret.setBasepath(basepath);
            float seconds = 0.0f;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if (!line.startsWith("#EXTINF:")) continue;
                    if ((line = line.substring(8)).endsWith(",")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    seconds = Float.parseFloat(line);
                    continue;
                }
                if (line.endsWith("m3u8")) {
                    return M3u8FileUtils.parseIndex(basepath + line);
                }
                ret.addTs(new M3u8Ts(line, seconds));
                seconds = 0.0f;
            }
            reader.close();
            return ret;
        }
        return null;
    }

    public static String merge(M3u8 m3u8, String tofile) throws IOException {
        List<M3u8Ts> mergeList = M3u8FileUtils.getLimitM3U8Ts(m3u8);
        File file = new File(tofile);
        FileOutputStream fos = new FileOutputStream(file);
        for (M3u8Ts ts : mergeList) {
            IOUtils.copyLarge((InputStream)new FileInputStream(new File(file.getParentFile(), ts.getFileName())), (OutputStream)fos);
        }
        fos.close();
        return tofile;
    }

    public static void merge(List<File> fileList, String toFile) throws IOException {
        File file = new File(toFile);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        for (File tsFile : fileList) {
            IOUtils.copyLarge((InputStream)new FileInputStream(tsFile), (OutputStream)fos);
        }
        fos.close();
    }

    public static void merge(M3u8 m3u8, String tofile, String basePath) throws IOException {
        List<M3u8Ts> mergeList = M3u8FileUtils.getLimitM3U8Ts(m3u8);
        File saveFile = new File(tofile);
        FileOutputStream fos = new FileOutputStream(saveFile);
        for (M3u8Ts ts : mergeList) {
            File file = new File(basePath, ts.getFileName());
            if (!file.isFile() || !file.exists()) continue;
            IOUtils.copyLarge((InputStream)new FileInputStream(file), (OutputStream)fos);
        }
        fos.close();
    }

    public static void moveFile(String sFile, String tFile) {
        try {
            FileUtils.moveFile((File)new File(sFile), (File)new File(tFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void clearDir(File dir) {
        if (dir.exists()) {
            if (dir.isFile()) {
                dir.delete();
            } else if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    M3u8FileUtils.clearDir(files[i]);
                }
                dir.delete();
            }
        }
    }

    public static List<M3u8Ts> getLimitM3U8Ts(M3u8 m3u8) {
        ArrayList<M3u8Ts> downList = new ArrayList();
        if (m3u8.getStartDownloadTime() < m3u8.getStartTime() || m3u8.getEndDownloadTime() > m3u8.getEndTime()) {
            downList = m3u8.getTsList();
            return downList;
        }
        if (m3u8.getStartDownloadTime() == -1L && m3u8.getEndDownloadTime() == -1L || m3u8.getEndDownloadTime() <= m3u8.getStartDownloadTime()) {
            downList = m3u8.getTsList();
        } else if (m3u8.getStartDownloadTime() == -1L && m3u8.getEndDownloadTime() > -1L) {
            for (M3u8Ts ts : m3u8.getTsList()) {
                if (ts.getLongDate() > m3u8.getEndDownloadTime()) continue;
                downList.add(ts);
            }
        } else if (m3u8.getStartDownloadTime() > -1L && m3u8.getEndDownloadTime() == -1L) {
            for (M3u8Ts ts : m3u8.getTsList()) {
                if (ts.getLongDate() < m3u8.getStartDownloadTime()) continue;
                downList.add(ts);
            }
        } else {
            for (M3u8Ts ts : m3u8.getTsList()) {
                if (m3u8.getStartDownloadTime() > ts.getLongDate() || ts.getLongDate() > m3u8.getEndDownloadTime()) continue;
                downList.add(ts);
            }
        }
        Log.e((String)"hdltag", (String)("getLimitM3U8Ts(MUtils.java:152):" + downList));
        return downList;
    }
}

