/*
 * Decompiled with CFR 0.152.
 */
package com.yc.m3u8.task;

import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import com.yc.m3u8.bean.M3u8;
import com.yc.m3u8.bean.M3u8Ts;
import com.yc.m3u8.inter.OnDownloadListener;
import com.yc.m3u8.inter.OnM3u8InfoListener;
import com.yc.m3u8.manager.M3u8InfoManger;
import com.yc.m3u8.utils.M3u8FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class M3u8DownloadTask {
    private OnDownloadListener onDownloadListener;
    private static final int WHAT_ON_ERROR = 1001;
    private static final int WHAT_ON_PROGRESS = 1002;
    private static final int WHAT_ON_SUCCESS = 1003;
    private String tempDir = Environment.getExternalStorageDirectory().getPath() + File.separator + "m3u8temp";
    private String saveFilePath = Environment.getExternalStorageDirectory().getPath() + File.separator + "11m3u8";
    private static int curTs = 0;
    private static int totalTs = 0;
    private static long itemFileSize = 0L;
    private long curLenght = 0L;
    private boolean isRunning = false;
    private String taskId = "0";
    private int threadCount = 3;
    private boolean isClearTempDir = true;
    private int readTimeout = 1800000;
    private int connTimeout = 10000;
    private Timer netSpeedTimer;
    private ExecutorService executor;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1001: {
                    M3u8DownloadTask.this.onDownloadListener.onError((Throwable)msg.obj);
                    break;
                }
                case 1002: {
                    M3u8DownloadTask.this.onDownloadListener.onDownloading(itemFileSize, totalTs, curTs);
                    break;
                }
                case 1003: {
                    if (M3u8DownloadTask.this.netSpeedTimer != null) {
                        M3u8DownloadTask.this.netSpeedTimer.cancel();
                    }
                    M3u8DownloadTask.this.onDownloadListener.onSuccess();
                }
            }
        }
    };

    public M3u8DownloadTask(String taskId) {
        this.taskId = taskId;
        this.tempDir = this.tempDir + File.separator + System.currentTimeMillis() / 86400000L + "-" + taskId;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void download(String url, OnDownloadListener onDownloadListener) {
        this.onDownloadListener = onDownloadListener;
        if (!this.isRunning()) {
            this.getM3U8Info(url);
        } else {
            this.handlerError(new Throwable("Task running"));
        }
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public boolean isClearTempDir() {
        return this.isClearTempDir;
    }

    public void setClearTempDir(boolean clearTempDir) {
        this.isClearTempDir = clearTempDir;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void getM3U8Info(String url) {
        M3u8InfoManger.getInstance().getM3U8Info(url, new OnM3u8InfoListener(){

            @Override
            public void onSuccess(final M3u8 m3U8) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            M3u8DownloadTask.this.startDownload(m3U8);
                            if (M3u8DownloadTask.this.executor != null) {
                                M3u8DownloadTask.this.executor.shutdown();
                            }
                            while (M3u8DownloadTask.this.executor != null && !M3u8DownloadTask.this.executor.isTerminated()) {
                                Thread.sleep(100L);
                            }
                            if (M3u8DownloadTask.this.isRunning) {
                                String saveFileName = M3u8DownloadTask.this.saveFilePath.substring(M3u8DownloadTask.this.saveFilePath.lastIndexOf("/") + 1);
                                String tempSaveFile = M3u8DownloadTask.this.tempDir + File.separator + saveFileName;
                                M3u8FileUtils.merge(m3U8, tempSaveFile, M3u8DownloadTask.this.tempDir);
                                M3u8FileUtils.moveFile(tempSaveFile, M3u8DownloadTask.this.saveFilePath);
                                if (M3u8DownloadTask.this.isClearTempDir) {
                                    M3u8DownloadTask.this.mHandler.postDelayed(new Runnable(){

                                        @Override
                                        public void run() {
                                            M3u8FileUtils.clearDir(new File(M3u8DownloadTask.this.tempDir));
                                        }
                                    }, 20000L);
                                }
                                M3u8DownloadTask.this.mHandler.sendEmptyMessage(1003);
                                M3u8DownloadTask.this.isRunning = false;
                            }
                        }
                        catch (InterruptedIOException e) {
                            return;
                        }
                        catch (IOException e) {
                            M3u8DownloadTask.this.handlerError(e);
                            return;
                        }
                        catch (InterruptedException e) {
                            M3u8DownloadTask.this.handlerError(e);
                        }
                    }
                }.start();
            }

            @Override
            public void onStart() {
                M3u8DownloadTask.this.onDownloadListener.onStart();
                M3u8DownloadTask.this.isRunning = true;
            }

            @Override
            public void onError(Throwable errorMsg) {
                M3u8DownloadTask.this.handlerError(errorMsg);
            }
        });
    }

    private void startDownload(M3u8 m3U8) {
        if (m3U8 == null) {
            this.handlerError(new Throwable("M3U8 is null"));
            return;
        }
        final File dir = new File(this.tempDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        totalTs = m3U8.getTsList().size();
        if (this.executor != null && this.executor.isTerminated()) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        this.executor = Executors.newFixedThreadPool(this.threadCount);
        final String basePath = m3U8.getBasepath();
        this.netSpeedTimer = new Timer();
        this.netSpeedTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                M3u8DownloadTask.this.onDownloadListener.onProgress(M3u8DownloadTask.this.curLenght);
            }
        }, 0L, 1000L);
        for (final M3u8Ts m3U8Ts : m3U8.getTsList()) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File file = new File(dir + File.separator + m3U8Ts.getFileName());
                    if (!file.exists()) {
                        FileOutputStream fos = null;
                        InputStream inputStream = null;
                        try {
                            String urlPath = "http".equals(m3U8Ts.getFile().substring(0, 4)) ? m3U8Ts.getFile() : basePath + m3U8Ts.getFile();
                            URL url = new URL(urlPath);
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setConnectTimeout(M3u8DownloadTask.this.connTimeout);
                            conn.setReadTimeout(M3u8DownloadTask.this.readTimeout);
                            if (conn.getResponseCode() == 200) {
                                inputStream = conn.getInputStream();
                                fos = new FileOutputStream(file);
                                int len = 0;
                                byte[] buf = new byte[0x800000];
                                while ((len = inputStream.read(buf)) != -1) {
                                    M3u8DownloadTask.this.curLenght = M3u8DownloadTask.this.curLenght + (long)len;
                                    fos.write(buf, 0, len);
                                }
                            } else {
                                M3u8DownloadTask.this.handlerError(new Throwable(String.valueOf(conn.getResponseCode())));
                            }
                        }
                        catch (MalformedURLException e) {
                            M3u8DownloadTask.this.handlerError(e);
                        }
                        catch (IOException e) {
                            M3u8DownloadTask.this.handlerError(e);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {}
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                        curTs++;
                        if (curTs == 3) {
                            itemFileSize = file.length();
                        }
                        M3u8DownloadTask.this.mHandler.sendEmptyMessage(1002);
                    }
                }
            });
        }
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public void setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
    }

    private void handlerError(Throwable e) {
        if (!"Task running".equals(e.getMessage())) {
            this.stop();
        }
        if ("thread interrupted".equals(e.getMessage())) {
            return;
        }
        Message msg = this.mHandler.obtainMessage();
        msg.obj = e;
        msg.what = 1001;
        this.mHandler.sendMessage(msg);
    }

    public void stop() {
        if (this.netSpeedTimer != null) {
            this.netSpeedTimer.cancel();
            this.netSpeedTimer = null;
        }
        this.isRunning = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

