/*
 * Decompiled with CFR 0.152.
 */
package com.yc.m3u8.manager;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.yc.m3u8.bean.M3u8;
import com.yc.m3u8.bean.M3u8Ts;
import com.yc.m3u8.inter.OnDownloadListener;
import com.yc.m3u8.utils.M3u8FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class M3u8LiveManger {
    private static M3u8LiveManger mM3U8LiveManger;
    private ExecutorService executor = Executors.newFixedThreadPool(5);
    private ExecutorService downloadExecutor = Executors.newFixedThreadPool(5);
    private Timer getM3U8InfoTimer;
    private String basePath;
    private OnDownloadListener onDownloadListener;
    private long curLenght = 0L;
    private int readTimeout = 1800000;
    private static int curTs;
    private static int totalTs;
    private static long itemFileSize;
    private int connTimeout = 10000;
    private static final int WHAT_ON_ERROR = 1001;
    private static final int WHAT_ON_PROGRESS = 1002;
    private static final int WHAT_ON_SUCCESS = 1003;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1001: {
                    M3u8LiveManger.this.onDownloadListener.onError((Throwable)msg.obj);
                    break;
                }
                case 1002: {
                    M3u8LiveManger.this.onDownloadListener.onDownloading(itemFileSize, totalTs, curTs);
                    break;
                }
                case 1003: {
                    if (M3u8LiveManger.this.netSpeedTimer != null) {
                        M3u8LiveManger.this.netSpeedTimer.cancel();
                    }
                    M3u8LiveManger.this.onDownloadListener.onSuccess();
                }
            }
        }
    };
    private Timer netSpeedTimer;
    private String tempDir = "/sdcard/111/" + System.currentTimeMillis();
    private List<File> downloadedFileList = new ArrayList<File>();
    private List<M3u8Ts> m3U8TsList = new ArrayList<M3u8Ts>();
    private String saveFilePath = "/sdcard/11/" + System.currentTimeMillis() + ".ts";

    private M3u8LiveManger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static M3u8LiveManger getInstance() {
        if (mM3U8LiveManger != null) return mM3U8LiveManger;
        Class<M3u8LiveManger> clazz = M3u8LiveManger.class;
        synchronized (M3u8LiveManger.class) {
            if (mM3U8LiveManger != null) return mM3U8LiveManger;
            mM3U8LiveManger = new M3u8LiveManger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mM3U8LiveManger;
        }
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public M3u8LiveManger setTempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    public void caching(String url, OnDownloadListener onDownloadListener1) {
        this.onDownloadListener = onDownloadListener1;
        this.onDownloadListener.onStart();
        this.netSpeedTimer = new Timer();
        this.netSpeedTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                M3u8LiveManger.this.onDownloadListener.onProgress(M3u8LiveManger.this.curLenght);
            }
        }, 0L, 1000L);
        this.startUpdateM3U8Info(url);
    }

    private void startDownloadM3U8() {
        final File dir = new File(this.tempDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (final M3u8Ts m3U8Ts : this.m3U8TsList) {
            this.downloadExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File file = new File(dir, m3U8Ts.getFileName());
                    if (!file.exists()) {
                        FileOutputStream fos = null;
                        InputStream inputStream = null;
                        try {
                            Log.i((String)"hdltag", (String)("run(M3U8DownloadTask.java:278):" + m3U8Ts.getFile()));
                            String urlPath = "http".equals(m3U8Ts.getFile().substring(0, 4)) ? m3U8Ts.getFile() : M3u8LiveManger.this.basePath + m3U8Ts.getFile();
                            URL url = new URL(urlPath);
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setConnectTimeout(M3u8LiveManger.this.connTimeout);
                            conn.setReadTimeout(M3u8LiveManger.this.readTimeout);
                            if (conn.getResponseCode() == 200) {
                                inputStream = conn.getInputStream();
                                fos = new FileOutputStream(file);
                                int len = 0;
                                byte[] buf = new byte[0x800000];
                                while ((len = inputStream.read(buf)) != -1) {
                                    M3u8LiveManger.this.curLenght = M3u8LiveManger.this.curLenght + (long)len;
                                    fos.write(buf, 0, len);
                                }
                                M3u8LiveManger.this.downloadedFileList.add(file);
                                Log.i((String)"hdltag", (String)("run(M3U8LiveManger.java:138):\u4e0b\u5b8c\u4e00\u4e2a\u4e86" + file.getAbsolutePath()));
                            } else {
                                M3u8LiveManger.this.handlerError(new Throwable(String.valueOf(conn.getResponseCode())));
                            }
                        }
                        catch (MalformedURLException e) {
                            M3u8LiveManger.this.handlerError(e);
                        }
                        catch (IOException e) {
                            M3u8LiveManger.this.handlerError(e);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {}
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                        curTs++;
                        if (curTs == 3) {
                            itemFileSize = file.length();
                        }
                        M3u8LiveManger.this.mHandler.sendEmptyMessage(1002);
                    }
                }
            });
        }
    }

    private void handlerError(Throwable e) {
        if (!"Task running".equals(e.getMessage())) {
            this.stop();
        }
        if ("thread interrupted".equals(e.getMessage())) {
            return;
        }
        Message msg = this.mHandler.obtainMessage();
        msg.obj = e;
        msg.what = 1001;
        this.mHandler.sendMessage(msg);
    }

    private void startUpdateM3U8Info(final String url) {
        if (this.getM3U8InfoTimer != null) {
            this.getM3U8InfoTimer.cancel();
            this.getM3U8InfoTimer = null;
        }
        this.getM3U8InfoTimer = new Timer();
        this.getM3U8InfoTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                M3u8LiveManger.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            M3u8 m3u8 = M3u8FileUtils.parseIndex(url);
                            if (m3u8 != null && m3u8.getTsList().size() > 0) {
                                M3u8LiveManger.this.basePath = m3u8.getBasepath();
                                M3u8LiveManger.this.addTs(m3u8.getTsList());
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            M3u8LiveManger.this.handlerError(e);
                        }
                    }
                });
            }
        }, 0L, 2000L);
    }

    private synchronized void addTs(List<M3u8Ts> tsList) {
        ArrayList<M3u8Ts> tempTsList = new ArrayList<M3u8Ts>();
        for (M3u8Ts m3U8Ts : tsList) {
            boolean isExisted = false;
            for (M3u8Ts mTs : this.m3U8TsList) {
                if (!mTs.getFile().equals(m3U8Ts.getFile())) continue;
                isExisted = true;
                break;
            }
            if (isExisted) continue;
            tempTsList.add(m3U8Ts);
        }
        if (tempTsList.size() > 0) {
            this.m3U8TsList.addAll(tempTsList);
        }
        Log.i((String)"hdltag", (String)("addTs(M3U8LiveManger.java:98):\u6709\u51e0\u4e2a\u4e86 ---->" + this.m3U8TsList.size()));
        for (M3u8Ts m3U8Ts : this.m3U8TsList) {
            Log.i((String)"hdltag", (String)("addTs(M3U8LiveManger.java:101):" + m3U8Ts.getFile()));
        }
        this.startDownloadM3U8();
    }

    public void stop() {
        Log.i((String)"hdltag", (String)"stop(M3U8LiveManger.java:106):\u8c03\u7528\u505c\u6b62\u4e86");
        if (this.getM3U8InfoTimer != null) {
            this.getM3U8InfoTimer.cancel();
            this.getM3U8InfoTimer = null;
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public M3u8LiveManger setSaveFile(String saveFile) {
        this.saveFilePath = saveFile;
        return this;
    }

    public String getCurrentTs() {
        try {
            M3u8FileUtils.merge(this.downloadedFileList, this.saveFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        Log.i((String)"hdltag", (String)("getCurrentTs(M3U8LiveManger.java:287):\u5df2\u4fdd\u5b58\u81f3 " + this.saveFilePath));
        return this.saveFilePath;
    }

    static {
        curTs = 0;
        totalTs = 0;
        itemFileSize = 0L;
    }
}

