/*
 * Decompiled with CFR 0.152.
 */
package com.yc.kernel.impl.media;

import android.app.Application;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.yc.kernel.inter.AbstractVideoPlayer;
import com.yc.kernel.inter.VideoPlayerListener;
import java.util.Map;

public class AndroidMediaPlayer
extends AbstractVideoPlayer {
    protected MediaPlayer mMediaPlayer;
    private int mBufferedPercent;
    private Context mAppContext;
    private boolean mIsPreparing;
    private MediaPlayer.OnErrorListener onErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            AndroidMediaPlayer.this.mPlayerEventListener.onError(3, "\u76d1\u542c\u5f02\u5e38" + what + ", extra: " + extra);
            return true;
        }
    };
    private MediaPlayer.OnCompletionListener onCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            AndroidMediaPlayer.this.mPlayerEventListener.onCompletion();
        }
    };
    private MediaPlayer.OnInfoListener onInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            if (what == 3) {
                if (AndroidMediaPlayer.this.mIsPreparing) {
                    AndroidMediaPlayer.this.mPlayerEventListener.onInfo(what, extra);
                    AndroidMediaPlayer.this.mIsPreparing = false;
                }
            } else {
                AndroidMediaPlayer.this.mPlayerEventListener.onInfo(what, extra);
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            AndroidMediaPlayer.this.mBufferedPercent = percent;
        }
    };
    private MediaPlayer.OnPreparedListener onPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            AndroidMediaPlayer.this.mPlayerEventListener.onPrepared();
            AndroidMediaPlayer.this.start();
        }
    };
    private MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            int videoWidth = mp.getVideoWidth();
            int videoHeight = mp.getVideoHeight();
            if (videoWidth != 0 && videoHeight != 0) {
                AndroidMediaPlayer.this.mPlayerEventListener.onVideoSizeChanged(videoWidth, videoHeight);
            }
        }
    };

    public AndroidMediaPlayer(Context context) {
        this.mAppContext = context instanceof Application ? context : context.getApplicationContext();
    }

    @Override
    public void initPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.setOptions();
        this.initListener();
    }

    private void initListener() {
        this.mMediaPlayer.setAudioStreamType(3);
        this.mMediaPlayer.setOnErrorListener(this.onErrorListener);
        this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
        this.mMediaPlayer.setOnInfoListener(this.onInfoListener);
        this.mMediaPlayer.setOnBufferingUpdateListener(this.onBufferingUpdateListener);
        this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
    }

    @Override
    public void setDataSource(String path, Map<String, String> headers) {
        if (path == null || path.length() == 0) {
            if (this.mPlayerEventListener != null) {
                this.mPlayerEventListener.onInfo(-1, 0);
            }
            return;
        }
        try {
            Uri uri = Uri.parse((String)path);
            this.mMediaPlayer.setDataSource(this.mAppContext, uri, headers);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError(2, e.getMessage());
        }
    }

    @Override
    public void setDataSource(AssetFileDescriptor fd) {
        try {
            this.mMediaPlayer.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void start() {
        try {
            this.mMediaPlayer.start();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void pause() {
        try {
            this.mMediaPlayer.pause();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.mMediaPlayer.stop();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void prepareAsync() {
        try {
            this.mIsPreparing = true;
            this.mMediaPlayer.prepareAsync();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void reset() {
        this.mMediaPlayer.reset();
        this.mMediaPlayer.setSurface(null);
        this.mMediaPlayer.setDisplay(null);
        this.mMediaPlayer.setVolume(1.0f, 1.0f);
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public void seekTo(long time) {
        try {
            this.mMediaPlayer.seekTo((int)time);
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void release() {
        this.mMediaPlayer.setOnErrorListener(null);
        this.mMediaPlayer.setOnCompletionListener(null);
        this.mMediaPlayer.setOnInfoListener(null);
        this.mMediaPlayer.setOnBufferingUpdateListener(null);
        this.mMediaPlayer.setOnPreparedListener(null);
        this.mMediaPlayer.setOnVideoSizeChangedListener(null);
        new Thread(){

            @Override
            public void run() {
                try {
                    AndroidMediaPlayer.this.mMediaPlayer.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public int getBufferedPercentage() {
        return this.mBufferedPercent;
    }

    @Override
    public void setSurface(Surface surface) {
        if (surface != null) {
            try {
                this.mMediaPlayer.setSurface(surface);
            }
            catch (Exception e) {
                this.mPlayerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void setDisplay(SurfaceHolder holder) {
        try {
            this.mMediaPlayer.setDisplay(holder);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void setVolume(float v1, float v2) {
        try {
            this.mMediaPlayer.setVolume(v1, v2);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void setLooping(boolean isLooping) {
        try {
            this.mMediaPlayer.setLooping(isLooping);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError(3, e.getMessage());
        }
    }

    @Override
    public void setOptions() {
    }

    @Override
    public void setSpeed(float speed) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                this.mMediaPlayer.setPlaybackParams(this.mMediaPlayer.getPlaybackParams().setSpeed(speed));
            }
            catch (Exception e) {
                this.mPlayerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public float getSpeed() {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                return this.mMediaPlayer.getPlaybackParams().getSpeed();
            }
            catch (Exception e) {
                this.mPlayerEventListener.onError(3, e.getMessage());
            }
        }
        return 1.0f;
    }

    @Override
    public long getTcpSpeed() {
        return 0L;
    }

    @Override
    public void setPlayerEventListener(VideoPlayerListener playerEventListener) {
        super.setPlayerEventListener(playerEventListener);
    }
}

