/*
 * Decompiled with CFR 0.152.
 */
package com.yc.kernel.impl.exo;

import android.app.Application;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.Handler;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.EventLogger;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.yc.kernel.impl.exo.ExoMediaSourceHelper;
import com.yc.kernel.inter.AbstractVideoPlayer;
import com.yc.kernel.inter.VideoPlayerListener;
import com.yc.kernel.utils.VideoLogUtils;
import java.util.Map;

public class ExoMediaPlayer
extends AbstractVideoPlayer
implements VideoListener,
Player.EventListener {
    protected Context mAppContext;
    protected SimpleExoPlayer mInternalPlayer;
    protected MediaSource mMediaSource;
    protected ExoMediaSourceHelper mMediaSourceHelper;
    private PlaybackParameters mSpeedPlaybackParameters;
    private int mLastReportedPlaybackState = 1;
    private boolean mLastReportedPlayWhenReady = false;
    private boolean mIsPreparing;
    private boolean mIsBuffering;
    private LoadControl mLoadControl;
    private RenderersFactory mRenderersFactory;
    private TrackSelector mTrackSelector;
    private MediaSourceEventListener mMediaSourceEventListener = new MediaSourceEventListener(){

        public void onReadingStarted(int windowIndex, MediaSource.MediaPeriodId mediaPeriodId) {
            if (ExoMediaPlayer.this.mPlayerEventListener != null && ExoMediaPlayer.this.mIsPreparing) {
                ExoMediaPlayer.this.mPlayerEventListener.onPrepared();
            }
        }
    };

    public ExoMediaPlayer(Context context) {
        this.mAppContext = context instanceof Application ? context : context.getApplicationContext();
        this.mMediaSourceHelper = ExoMediaSourceHelper.getInstance(context);
    }

    @Override
    public void initPlayer() {
        this.mInternalPlayer = new SimpleExoPlayer.Builder(this.mAppContext, this.mRenderersFactory == null ? (this.mRenderersFactory = new DefaultRenderersFactory(this.mAppContext)) : this.mRenderersFactory, this.mTrackSelector == null ? (this.mTrackSelector = new DefaultTrackSelector(this.mAppContext)) : this.mTrackSelector, this.mLoadControl == null ? (this.mLoadControl = new DefaultLoadControl()) : this.mLoadControl, (BandwidthMeter)DefaultBandwidthMeter.getSingletonInstance((Context)this.mAppContext), Util.getLooper(), new AnalyticsCollector(Clock.DEFAULT), true, Clock.DEFAULT).build();
        this.setOptions();
        if (VideoLogUtils.isIsLog() && this.mTrackSelector instanceof MappingTrackSelector) {
            this.mInternalPlayer.addAnalyticsListener((AnalyticsListener)new EventLogger((MappingTrackSelector)this.mTrackSelector, "ExoPlayer"));
        }
        this.initListener();
    }

    private void initListener() {
        this.mInternalPlayer.addListener((Player.EventListener)this);
        this.mInternalPlayer.addVideoListener((VideoListener)this);
    }

    public void setTrackSelector(TrackSelector trackSelector) {
        this.mTrackSelector = trackSelector;
    }

    public void setRenderersFactory(RenderersFactory renderersFactory) {
        this.mRenderersFactory = renderersFactory;
    }

    public void setLoadControl(LoadControl loadControl) {
        this.mLoadControl = loadControl;
    }

    @Override
    public void setDataSource(String path, Map<String, String> headers) {
        if (path == null || path.length() == 0) {
            if (this.mPlayerEventListener != null) {
                this.mPlayerEventListener.onInfo(-1, 0);
            }
            return;
        }
        this.mMediaSource = this.mMediaSourceHelper.getMediaSource(path, headers);
    }

    @Override
    public void setDataSource(AssetFileDescriptor fd) {
    }

    @Override
    public void prepareAsync() {
        if (this.mInternalPlayer == null) {
            return;
        }
        if (this.mMediaSource == null) {
            return;
        }
        if (this.mSpeedPlaybackParameters != null) {
            this.mInternalPlayer.setPlaybackParameters(this.mSpeedPlaybackParameters);
        }
        this.mIsPreparing = true;
        this.mMediaSource.addEventListener(new Handler(), this.mMediaSourceEventListener);
        this.mInternalPlayer.prepare(this.mMediaSource);
    }

    @Override
    public void start() {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(true);
    }

    @Override
    public void pause() {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(false);
    }

    @Override
    public void stop() {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.stop();
    }

    @Override
    public void reset() {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.stop(true);
            this.mInternalPlayer.setVideoSurface(null);
            this.mIsPreparing = false;
            this.mIsBuffering = false;
            this.mLastReportedPlaybackState = 1;
            this.mLastReportedPlayWhenReady = false;
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mInternalPlayer == null) {
            return false;
        }
        int state = this.mInternalPlayer.getPlaybackState();
        switch (state) {
            case 2: 
            case 3: {
                return this.mInternalPlayer.getPlayWhenReady();
            }
        }
        return false;
    }

    @Override
    public void seekTo(long time) {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.seekTo(time);
    }

    @Override
    public void release() {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.removeListener((Player.EventListener)this);
            this.mInternalPlayer.removeVideoListener((VideoListener)this);
            final SimpleExoPlayer player = this.mInternalPlayer;
            this.mInternalPlayer = null;
            new Thread(){

                @Override
                public void run() {
                    player.release();
                }
            }.start();
        }
        this.mIsPreparing = false;
        this.mIsBuffering = false;
        this.mLastReportedPlaybackState = 1;
        this.mLastReportedPlayWhenReady = false;
        this.mSpeedPlaybackParameters = null;
    }

    @Override
    public long getCurrentPosition() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getDuration();
    }

    @Override
    public int getBufferedPercentage() {
        return this.mInternalPlayer == null ? 0 : this.mInternalPlayer.getBufferedPercentage();
    }

    @Override
    public void setSurface(Surface surface) {
        if (surface != null) {
            try {
                if (this.mInternalPlayer != null) {
                    this.mInternalPlayer.setVideoSurface(surface);
                }
            }
            catch (Exception e) {
                this.mPlayerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void setDisplay(SurfaceHolder holder) {
        if (holder == null) {
            this.setSurface(null);
        } else {
            this.setSurface(holder.getSurface());
        }
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setVolume((leftVolume + rightVolume) / 2.0f);
        }
    }

    @Override
    public void setLooping(boolean isLooping) {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setRepeatMode(isLooping ? 2 : 0);
        }
    }

    @Override
    public void setOptions() {
        this.mInternalPlayer.setPlayWhenReady(true);
    }

    @Override
    public void setSpeed(float speed) {
        PlaybackParameters playbackParameters;
        this.mSpeedPlaybackParameters = playbackParameters = new PlaybackParameters(speed);
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setPlaybackParameters(playbackParameters);
        }
    }

    @Override
    public float getSpeed() {
        if (this.mSpeedPlaybackParameters != null) {
            return this.mSpeedPlaybackParameters.speed;
        }
        return 1.0f;
    }

    @Override
    public long getTcpSpeed() {
        return 0L;
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        if (this.mPlayerEventListener == null) {
            return;
        }
        if (this.mIsPreparing) {
            return;
        }
        if (this.mLastReportedPlayWhenReady != playWhenReady || this.mLastReportedPlaybackState != playbackState) {
            switch (playbackState) {
                case 1: {
                    break;
                }
                case 2: {
                    this.mPlayerEventListener.onInfo(701, this.getBufferedPercentage());
                    this.mIsBuffering = true;
                    break;
                }
                case 3: {
                    if (!this.mIsBuffering) break;
                    this.mPlayerEventListener.onInfo(702, this.getBufferedPercentage());
                    this.mIsBuffering = false;
                    break;
                }
                case 4: {
                    this.mPlayerEventListener.onCompletion();
                    break;
                }
            }
            this.mLastReportedPlaybackState = playbackState;
            this.mLastReportedPlayWhenReady = playWhenReady;
        }
    }

    public void onPlayerError(ExoPlaybackException error) {
        if (this.mPlayerEventListener != null) {
            int type = error.type;
            if (type == 0) {
                this.mPlayerEventListener.onError(1, error.getMessage());
            } else if (type == 1 || type == 2 || type == 3 || type == 4) {
                this.mPlayerEventListener.onError(3, error.getMessage());
            }
        }
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        if (this.mPlayerEventListener != null) {
            this.mPlayerEventListener.onVideoSizeChanged(width, height);
            if (unappliedRotationDegrees > 0) {
                this.mPlayerEventListener.onInfo(10001, unappliedRotationDegrees);
            }
        }
    }

    public void onRenderedFirstFrame() {
        if (this.mPlayerEventListener != null && this.mIsPreparing) {
            this.mPlayerEventListener.onInfo(3, 0);
            this.mIsPreparing = false;
        }
    }

    @Override
    public void setPlayerEventListener(VideoPlayerListener playerEventListener) {
        super.setPlayerEventListener(playerEventListener);
    }
}

