/*
 * Decompiled with CFR 0.152.
 */
package com.yc.kernel.impl.ijk;

import android.app.Application;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.yc.kernel.impl.ijk.RawDataSourceProvider;
import com.yc.kernel.inter.AbstractVideoPlayer;
import com.yc.kernel.utils.VideoLogUtils;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.IjkTimedText;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

public class IjkVideoPlayer
extends AbstractVideoPlayer {
    protected IjkMediaPlayer mMediaPlayer;
    private int mBufferedPercent;
    private Context mAppContext;
    private IMediaPlayer.OnErrorListener onErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer iMediaPlayer, int framework_err, int impl_err) {
            IjkVideoPlayer.this.mPlayerEventListener.onError();
            VideoLogUtils.d("IjkVideoPlayer----listener---------onError \u2014\u2014> STATE_ERROR \u2014\u2014\u2014\u2014 what\uff1a" + framework_err + ", extra: " + impl_err);
            return true;
        }
    };
    private IMediaPlayer.OnCompletionListener onCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer iMediaPlayer) {
            IjkVideoPlayer.this.mPlayerEventListener.onCompletion();
            VideoLogUtils.d("IjkVideoPlayer----listener---------onCompletion \u2014\u2014> STATE_COMPLETED");
        }
    };
    private IMediaPlayer.OnInfoListener onInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer iMediaPlayer, int what, int extra) {
            IjkVideoPlayer.this.mPlayerEventListener.onInfo(what, extra);
            VideoLogUtils.d("IjkVideoPlayer----listener---------onInfo \u2014\u2014> \u2014\u2014\u2014\u2014 what\uff1a" + what + ", extra: " + extra);
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int percent) {
            IjkVideoPlayer.this.mBufferedPercent = percent;
        }
    };
    private IMediaPlayer.OnPreparedListener onPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer iMediaPlayer) {
            IjkVideoPlayer.this.mPlayerEventListener.onPrepared();
            VideoLogUtils.d("IjkVideoPlayer----listener---------onPrepared \u2014\u2014> STATE_PREPARED");
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer iMediaPlayer, int width, int height, int sar_num, int sar_den) {
            int videoWidth = iMediaPlayer.getVideoWidth();
            int videoHeight = iMediaPlayer.getVideoHeight();
            if (videoWidth != 0 && videoHeight != 0) {
                IjkVideoPlayer.this.mPlayerEventListener.onVideoSizeChanged(videoWidth, videoHeight);
            }
            VideoLogUtils.d("IjkVideoPlayer----listener---------onVideoSizeChanged \u2014\u2014> WIDTH\uff1a" + width + "\uff0c HEIGHT\uff1a" + height);
        }
    };
    private IMediaPlayer.OnTimedTextListener onTimedTextListener = new IMediaPlayer.OnTimedTextListener(){

        public void onTimedText(IMediaPlayer iMediaPlayer, IjkTimedText ijkTimedText) {
        }
    };
    private IMediaPlayer.OnSeekCompleteListener onSeekCompleteListener = new IMediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(IMediaPlayer iMediaPlayer) {
        }
    };

    public IjkVideoPlayer(Context context) {
        this.mAppContext = context instanceof Application ? context : context.getApplicationContext();
    }

    @Override
    public void initPlayer() {
        this.mMediaPlayer = new IjkMediaPlayer();
        IjkMediaPlayer.native_setLogLevel((int)(VideoLogUtils.isIsLog() ? 4 : 8));
        this.setOptions();
        this.mMediaPlayer.setAudioStreamType(3);
        this.initListener();
    }

    @Override
    public void setOptions() {
    }

    private void initListener() {
        this.mMediaPlayer.setOnErrorListener(this.onErrorListener);
        this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
        this.mMediaPlayer.setOnInfoListener(this.onInfoListener);
        this.mMediaPlayer.setOnBufferingUpdateListener(this.onBufferingUpdateListener);
        this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        this.mMediaPlayer.setOnSeekCompleteListener(this.onSeekCompleteListener);
        this.mMediaPlayer.setOnTimedTextListener(this.onTimedTextListener);
        this.mMediaPlayer.setOnNativeInvokeListener(new IjkMediaPlayer.OnNativeInvokeListener(){

            public boolean onNativeInvoke(int i, Bundle bundle) {
                return true;
            }
        });
    }

    @Override
    public void setDataSource(String path, Map<String, String> headers) {
        if (path == null || path.length() == 0) {
            if (this.mPlayerEventListener != null) {
                this.mPlayerEventListener.onInfo(-1, 0);
            }
            return;
        }
        try {
            Uri uri = Uri.parse((String)path);
            if ("android.resource".equals(uri.getScheme())) {
                RawDataSourceProvider rawDataSourceProvider = RawDataSourceProvider.create(this.mAppContext, uri);
                this.mMediaPlayer.setDataSource((IMediaDataSource)rawDataSourceProvider);
            } else {
                String userAgent;
                if (headers != null && !TextUtils.isEmpty((CharSequence)(userAgent = headers.get("User-Agent")))) {
                    this.mMediaPlayer.setOption(1, "user_agent", userAgent);
                }
                this.mMediaPlayer.setDataSource(this.mAppContext, uri, headers);
            }
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void setDataSource(AssetFileDescriptor fd) {
        try {
            this.mMediaPlayer.setDataSource((IMediaDataSource)new RawDataSourceProvider(fd));
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void setSurface(Surface surface) {
        this.mMediaPlayer.setSurface(surface);
    }

    @Override
    public void prepareAsync() {
        try {
            this.mMediaPlayer.prepareAsync();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void pause() {
        try {
            this.mMediaPlayer.pause();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void start() {
        try {
            this.mMediaPlayer.start();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void stop() {
        try {
            this.mMediaPlayer.stop();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void reset() {
        this.mMediaPlayer.reset();
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        this.setOptions();
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public void seekTo(long time) {
        try {
            this.mMediaPlayer.seekTo((long)((int)time));
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void release() {
        this.mMediaPlayer.setOnErrorListener(null);
        this.mMediaPlayer.setOnCompletionListener(null);
        this.mMediaPlayer.setOnInfoListener(null);
        this.mMediaPlayer.setOnBufferingUpdateListener(null);
        this.mMediaPlayer.setOnPreparedListener(null);
        this.mMediaPlayer.setOnVideoSizeChangedListener(null);
        new Thread(){

            @Override
            public void run() {
                try {
                    IjkVideoPlayer.this.mMediaPlayer.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public int getBufferedPercentage() {
        return this.mBufferedPercent;
    }

    @Override
    public void setDisplay(SurfaceHolder holder) {
        this.mMediaPlayer.setDisplay(holder);
    }

    @Override
    public void setVolume(float v1, float v2) {
        this.mMediaPlayer.setVolume(v1, v2);
    }

    @Override
    public void setLooping(boolean isLooping) {
        this.mMediaPlayer.setLooping(isLooping);
    }

    @Override
    public void setSpeed(float speed) {
        this.mMediaPlayer.setSpeed(speed);
    }

    @Override
    public float getSpeed() {
        return this.mMediaPlayer.getSpeed(0.0f);
    }

    @Override
    public long getTcpSpeed() {
        return this.mMediaPlayer.getTcpSpeed();
    }
}

