/*
 * Decompiled with CFR 0.152.
 */
package com.yc.kernel.impl.exo;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.database.ExoDatabaseProvider;
import com.google.android.exoplayer2.ext.rtmp.RtmpDataSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSourceFactory;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;

public final class ExoMediaSourceHelper {
    private static ExoMediaSourceHelper sInstance;
    private final String mUserAgent;
    private Context mAppContext;
    private HttpDataSource.Factory mHttpDataSourceFactory;
    private Cache mCache;

    private ExoMediaSourceHelper(Context context) {
        this.mAppContext = context instanceof Application ? context : context.getApplicationContext();
        this.mUserAgent = Util.getUserAgent((Context)this.mAppContext, (String)this.mAppContext.getApplicationInfo().name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExoMediaSourceHelper getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<ExoMediaSourceHelper> clazz = ExoMediaSourceHelper.class;
        synchronized (ExoMediaSourceHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ExoMediaSourceHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public MediaSource getMediaSource(String uri) {
        return this.getMediaSource(uri, null, false);
    }

    public MediaSource getMediaSource(String uri, Map<String, String> headers) {
        return this.getMediaSource(uri, headers, false);
    }

    public MediaSource getMediaSource(String uri, boolean isCache) {
        return this.getMediaSource(uri, null, isCache);
    }

    public MediaSource getMediaSource(String uri, Map<String, String> headers, boolean isCache) {
        Uri contentUri = Uri.parse((String)uri);
        if ("rtmp".equals(contentUri.getScheme())) {
            RtmpDataSourceFactory rtmpDataSourceFactory = new RtmpDataSourceFactory(null);
            return new ProgressiveMediaSource.Factory((DataSource.Factory)rtmpDataSourceFactory).createMediaSource(contentUri);
        }
        int contentType = this.inferContentType(uri);
        DataSource.Factory factory = isCache ? this.getCacheDataSourceFactory() : this.getDataSourceFactory();
        if (this.mHttpDataSourceFactory != null) {
            this.setHeaders(headers);
        }
        switch (contentType) {
            case 0: {
                return new DashMediaSource.Factory(factory).createMediaSource(contentUri);
            }
            case 1: {
                return new SsMediaSource.Factory(factory).createMediaSource(contentUri);
            }
            case 2: {
                return new HlsMediaSource.Factory(factory).createMediaSource(contentUri);
            }
        }
        return new ProgressiveMediaSource.Factory(factory).createMediaSource(contentUri);
    }

    private int inferContentType(String fileName) {
        if ((fileName = Util.toLowerInvariant((String)fileName)).contains(".mpd")) {
            return 0;
        }
        if (fileName.contains(".m3u8")) {
            return 2;
        }
        if (fileName.matches(".*\\.ism(l)?(/manifest(\\(.+\\))?)?")) {
            return 1;
        }
        return 3;
    }

    private DataSource.Factory getCacheDataSourceFactory() {
        if (this.mCache == null) {
            this.mCache = this.newCache();
        }
        return new CacheDataSourceFactory(this.mCache, this.getDataSourceFactory(), 2);
    }

    private Cache newCache() {
        return new SimpleCache(new File(this.mAppContext.getExternalCacheDir(), "exo-video-cache"), (CacheEvictor)new LeastRecentlyUsedCacheEvictor(0x20000000L), (DatabaseProvider)new ExoDatabaseProvider(this.mAppContext));
    }

    private DataSource.Factory getDataSourceFactory() {
        return new DefaultDataSourceFactory(this.mAppContext, this.getHttpDataSourceFactory());
    }

    private DataSource.Factory getHttpDataSourceFactory() {
        if (this.mHttpDataSourceFactory == null) {
            this.mHttpDataSourceFactory = new DefaultHttpDataSourceFactory(this.mUserAgent, null, 8000, 8000, true);
        }
        return this.mHttpDataSourceFactory;
    }

    private void setHeaders(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey();
                String value = header.getValue();
                if (TextUtils.equals((CharSequence)key, (CharSequence)"User-Agent")) {
                    if (TextUtils.isEmpty((CharSequence)value)) continue;
                    try {
                        Field userAgentField = this.mHttpDataSourceFactory.getClass().getDeclaredField("userAgent");
                        userAgentField.setAccessible(true);
                        userAgentField.set(this.mHttpDataSourceFactory, value);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.mHttpDataSourceFactory.getDefaultRequestProperties().set(key, value);
            }
        }
    }

    public void setCache(Cache cache) {
        this.mCache = cache;
    }
}

