/*
 * Decompiled with CFR 0.152.
 */
package com.yc.videocache.cache;

import com.yc.videocache.HttpProxyCacheServer;
import com.yc.videocache.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;

public class PreloadTask
implements Runnable {
    public String mRawUrl;
    public int mPosition;
    public HttpProxyCacheServer mCacheServer;
    private boolean mIsCanceled;
    private boolean mIsExecuted;

    @Override
    public void run() {
        if (!this.mIsCanceled) {
            this.start();
        }
        this.mIsExecuted = false;
        this.mIsCanceled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Logger.info("\u5f00\u59cb\u9884\u52a0\u8f7d\uff1a" + this.mPosition);
        HttpURLConnection connection = null;
        try {
            int length;
            String proxyUrl = this.mCacheServer.getProxyUrl(this.mRawUrl);
            URL url = new URL(proxyUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            int read = -1;
            byte[] bytes = new byte[8192];
            while ((length = ((InputStream)in).read(bytes)) != -1) {
                if (!this.mIsCanceled && (read += length) < 524288) continue;
                Logger.info("\u7ed3\u675f\u9884\u52a0\u8f7d\uff1a" + this.mPosition);
                break;
            }
            if (read == -1) {
                Logger.info("\u9884\u52a0\u8f7d\u5931\u8d25\uff1a" + this.mPosition);
                File cacheFile = this.mCacheServer.getCacheFile(this.mRawUrl);
                if (cacheFile.exists()) {
                    cacheFile.delete();
                }
            }
        }
        catch (Exception e) {
            Logger.info("\u5f02\u5e38\u7ed3\u675f\u9884\u52a0\u8f7d\uff1a" + this.mPosition);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void executeOn(ExecutorService executorService) {
        if (this.mIsExecuted) {
            return;
        }
        this.mIsExecuted = true;
        executorService.submit(this);
    }

    public void cancel() {
        if (this.mIsExecuted) {
            this.mIsCanceled = true;
        }
    }
}

