/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.wrapper;

import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;

public class WrapperObserver<T>
implements Observer<T> {
    private final Observer<T> observer;
    private final String filterClass;
    private final String filterMethod;

    public WrapperObserver(Observer<T> observer) {
        this.observer = observer;
        this.filterClass = null;
        this.filterMethod = null;
    }

    public WrapperObserver(Observer<T> observer, String filterClass, String filterMethod) {
        this.observer = observer;
        this.filterClass = filterClass;
        this.filterMethod = filterMethod;
    }

    public void onChanged(@Nullable T t) {
        if (this.isCallOnObserve()) {
            return;
        }
        try {
            this.observer.onChanged(t);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isCallOnObserve() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (this.filterClass == null || this.filterMethod == null) {
                if (stackTrace != null && stackTrace.length > 0) {
                    for (StackTraceElement element : stackTrace) {
                        if (!"android.arch.lifecycle.LiveData".equals(element.getClassName()) || !"observeForever".equals(element.getMethodName())) continue;
                        return true;
                    }
                }
            } else if (stackTrace != null && stackTrace.length > 0) {
                for (StackTraceElement element : stackTrace) {
                    if (!this.filterClass.equals(element.getClassName()) || !this.filterMethod.equals(element.getMethodName())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

