/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.event;

import com.yccx.livebuslib.data.BusMutableLiveData;
import com.yccx.livebuslib.utils.BusLibUtils;
import java.util.HashMap;
import java.util.Map;

public final class LiveDataBus {
    private final Map<String, BusMutableLiveData<Object>> bus = new HashMap<String, BusMutableLiveData<Object>>();
    private boolean lifecycleObserverAlwaysActive = true;

    private LiveDataBus() {
    }

    public static LiveDataBus get() {
        return SingletonHolder.DEFAULT_BUS;
    }

    public synchronized <T> BusMutableLiveData<T> with(String key, Class<T> type) {
        BusLibUtils.checkNull(key);
        BusLibUtils.checkNull(type);
        if (!this.bus.containsKey(key)) {
            this.bus.put(key, new BusMutableLiveData(key));
        }
        return this.bus.get(key);
    }

    public BusMutableLiveData<Object> with(String key) {
        BusLibUtils.checkNull(key);
        return this.with(key, Object.class);
    }

    public Map<String, BusMutableLiveData<Object>> getBus() {
        return this.bus;
    }

    public void lifecycleObserverAlwaysActive(boolean active) {
        this.lifecycleObserverAlwaysActive = active;
    }

    public boolean isLifecycleObserverAlwaysActive() {
        return this.lifecycleObserverAlwaysActive;
    }

    private static class SingletonHolder {
        private static final LiveDataBus DEFAULT_BUS = new LiveDataBus();

        private SingletonHolder() {
        }
    }
}

