/*
 * Decompiled with CFR 0.152.
 */
package com.yccx.livebuslib.data;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.yccx.livebuslib.helper.BusWeakHandler;
import com.yccx.livebuslib.wrapper.WrapperObserver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BusMutableLiveData<T>
extends MutableLiveData<T> {
    private Map<Observer, Observer> observerMap = new HashMap<Observer, Observer>();
    private BusWeakHandler mainHandler = new BusWeakHandler(Looper.getMainLooper());

    public void setValue(T value) {
        super.setValue(value);
    }

    public void postValue(T value) {
        this.mainHandler.post(new PostValueTask(value));
    }

    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        super.observe(owner, observer);
        this.hook(observer);
    }

    public void observeForever(@NonNull Observer<T> observer) {
        if (!this.observerMap.containsKey(observer)) {
            this.observerMap.put(observer, new WrapperObserver<T>(observer));
        }
        super.observeForever(this.observerMap.get(observer));
    }

    public void removeObserver(@NonNull Observer<T> observer) {
        Observer realObserver = null;
        realObserver = this.observerMap.containsKey(observer) ? this.observerMap.remove(observer) : observer;
        super.removeObserver(realObserver);
    }

    public void observeSticky(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        super.observe(owner, observer);
    }

    public void observeStickyForever(@NonNull Observer<T> observer) {
        super.observeForever(observer);
    }

    private void hook(@NonNull Observer<T> observer) {
        try {
            Class<LiveData> classLiveData = LiveData.class;
            Field fieldObservers = classLiveData.getDeclaredField("mObservers");
            fieldObservers.setAccessible(true);
            Object objectObservers = fieldObservers.get((Object)this);
            Class<?> classObservers = objectObservers.getClass();
            Method methodGet = classObservers.getDeclaredMethod("get", Object.class);
            methodGet.setAccessible(true);
            Object objectWrapperEntry = methodGet.invoke(objectObservers, observer);
            Object objectWrapper = null;
            if (objectWrapperEntry instanceof Map.Entry) {
                objectWrapper = ((Map.Entry)objectWrapperEntry).getValue();
            }
            if (objectWrapper == null) {
                throw new NullPointerException("Wrapper can not be bull!");
            }
            Class<?> classObserverWrapper = objectWrapper.getClass().getSuperclass();
            Field fieldLastVersion = null;
            if (classObserverWrapper != null) {
                fieldLastVersion = classObserverWrapper.getDeclaredField("mLastVersion");
                fieldLastVersion.setAccessible(true);
                Field fieldVersion = classLiveData.getDeclaredField("mVersion");
                fieldVersion.setAccessible(true);
                Object objectVersion = fieldVersion.get((Object)this);
                fieldLastVersion.set(objectWrapper, objectVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class PostValueTask
    implements Runnable {
        private T newValue;

        public PostValueTask(T newValue) {
            this.newValue = newValue;
        }

        @Override
        public void run() {
            BusMutableLiveData.this.setValue(this.newValue);
        }
    }
}

