/*
 * Decompiled with CFR 0.152.
 */
package cn.xabad.maya.extensions;

import android.content.Context;
import android.text.format.Formatter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0002H\u0007\u001a\u0012\u0010\u0007\u001a\u00020\u0003*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\u0007\u001a\u00020\u0003*\u00020\n2\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0002H\u0007\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\u0003\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"createDirAndFile", "", "Ljava/io/File;", "", "deleteFile", "", "drop", "fileSize", "context", "Landroid/content/Context;", "", "forceMkdir", "ifNotExistCreateDir", "writeStreamToFile", "inputStream", "Ljava/io/InputStream;", "extensions_release"})
public final class FileExtKt {
    @NotNull
    public static final String fileSize(long $receiver, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = Formatter.formatFileSize((Context)context, (long)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"android.text.format.Form\u2026atFileSize(context, this)");
        return string;
    }

    @NotNull
    public static final String fileSize(@NotNull File $receiver, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = Formatter.formatFileSize((Context)context, (long)$receiver.length());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"android.text.format.Form\u2026e(context, this.length())");
        return string;
    }

    public static final void deleteFile(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.exists()) {
            return;
        }
        if ($receiver.isDirectory()) {
            File[] files;
            File[] fileArray = $receiver.listFiles();
            if (fileArray == null) {
                return;
            }
            File[] $receiver$iv = files = fileArray;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it;
                File file = it = (element$iv = $receiver$iv[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                FileExtKt.deleteFile(file);
            }
            $receiver.delete();
        } else {
            File to = new File($receiver.getAbsolutePath() + System.nanoTime());
            $receiver.renameTo(to);
            to.delete();
        }
    }

    public static final void drop(@NotNull File $receiver) throws IOException {
        File[] files;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        File[] fileArray = $receiver.listFiles();
        if (fileArray == null) {
            throw (Throwable)new IOException("not a readable directory: " + $receiver);
        }
        File[] $receiver$iv = files = fileArray;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it;
            File file = it = (element$iv = $receiver$iv[i]);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            if (file.isDirectory()) {
                FileExtKt.drop(it);
            }
            if (it.delete()) continue;
            throw (Throwable)new IOException("failed to delete file: " + it);
        }
    }

    public static final boolean createDirAndFile(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return !$receiver.exists() ? ($receiver.getParentFile().exists() ? $receiver.createNewFile() : $receiver.getParentFile().mkdirs() && $receiver.createNewFile()) : true;
    }

    public static final boolean createDirAndFile(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FileExtKt.createDirAndFile(new File($receiver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeStreamToFile(@NotNull String $receiver, @NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            long l;
            InputStream it = (InputStream)closeable;
            Closeable closeable2 = new FileOutputStream($receiver);
            Throwable throwable2 = null;
            try {
                FileOutputStream it2 = (FileOutputStream)closeable2;
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it2, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void forceMkdir(@NotNull File $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.exists()) {
            if (!$receiver.isDirectory()) {
                String message = "File " + $receiver + " exists and is " + "not a directory. Unable to create directory.";
                throw (Throwable)new IOException(message);
            }
        } else if (!$receiver.mkdirs() && !$receiver.isDirectory()) {
            String message = "Unable to create directory " + $receiver;
            throw (Throwable)new IOException(message);
        }
    }

    public static final void ifNotExistCreateDir(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        File file = new File($receiver);
        FileExtKt.forceMkdir(file);
    }
}

