// +----------------------------------------------------------------------
// | CreateTime: 2018/3/13 
// +----------------------------------------------------------------------
// | Author:     xab
// +----------------------------------------------------------------------
// | CopyRight:  http://www.xabad.cn
// +----------------------------------------------------------------------

package cn.xabad.maya.extensions

import android.graphics.Rect


/**
 * @author xab
 * @create 2018-03-11 15:39
 * @desc
 */
fun Rect.diff(lastRect: Rect):Int{
    return (left - lastRect.left).square() +
        (bottom - lastRect.bottom).square() +
        (top - lastRect.top).square() +
        (right - lastRect.right).square()
}

fun Rect.expandArea():Rect{
    val x=centerX()
    val y=centerY()
    val d= maxOf(width(),height())
    return Rect( x-d, y-d, x+d, y+d)
}