package cn.xabad.maya.extensions

import android.content.Context
import android.graphics.drawable.Drawable
import android.os.Build
import android.support.annotation.DrawableRes

/**
 * @author xab
 * @create 2018-04-25 14:28
 * @desc
 */
@Suppress("DEPRECATION")
fun Context.drawable(@DrawableRes id: Int): Drawable {
    return if (Build.VERSION.SDK_INT < 21) {
        resources.getDrawable(id)
    } else {
        resources.getDrawable(id, theme)
    }
}

fun Context.px2dip(pxValue: Float): Int {
    val scale = resources.displayMetrics.density
    return (pxValue / scale + 0.5f).toInt()
}

fun Context.dip2px(dpValue: Float): Int {
    val scale = resources.displayMetrics.density
    return (dpValue * scale + 0.5f).toInt()
}