package cn.xabad.maya.extensions

import android.app.Activity
import android.app.ActivityManager
import android.content.Context
import android.content.Intent
import android.content.pm.ResolveInfo
import android.net.Uri


/**
 * @author xab
 * @create 2018-02-01 15:38
 * @desc
 */

fun Activity.isServiceRunning(serviceClass: Class<*>): Boolean {
    if (isFinishing) return false
    val manager = getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
    return manager.getRunningServices(
        Integer.MAX_VALUE).any { serviceClass.name == it.service.className }
}

fun Activity.getAppDetailSettingIntent() {
    val localIntent = Intent()
    localIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
    localIntent.action = "android.settings.APPLICATION_DETAILS_SETTINGS"
    localIntent.data = Uri.fromParts("package", packageName, null)
    startActivity(localIntent)
}

fun Activity.showAllApp():List<ResolveInfo>{
    val intent = Intent(Intent.ACTION_MAIN, null)
    intent.addCategory(Intent.CATEGORY_LAUNCHER)
    return packageManager.queryIntentActivities(intent, 0)
    //for循环遍历ResolveInfo对象获取包名和类名
//    for (i in 0 until apps.size) {
//        val info = apps[i]
//        val packageName = info.activityInfo.packageName
//        val cls = info.activityInfo.name
//        val name = info.activityInfo.loadLabel(packageManager)
//    }
}