@file:JvmName("DisplayUtil")

package cn.xabad.maya.extensions

import android.content.Context


/**
 * @author xab
 * @create 2018-02-02 17:54
 * @desc
 */
fun Context.px2dip(pxValue: Float): Int {
    val scale = resources.displayMetrics.density
    return (pxValue / scale + 0.5f).toInt()
}

fun Context.dip2px(dpValue: Float): Int {
    val scale = resources.displayMetrics.density
    return (dpValue * scale + 0.5f).toInt()
}

@Synchronized
fun Context.getVoiceLineWight(seconds: Int): Int {
    //1-2s是最短的。2-10s每秒增加一个单位。10-60s每10s增加一个单位。
    return when {
        seconds <= 2 -> dip2px(90f)
        seconds <= 10 -> dip2px((90 + 8 * seconds).toFloat())
        else -> dip2px((170 + 10 * (seconds / 10)).toFloat())
    }
}