package cn.xabad.maya.extensions

import io.reactivex.Observable
import io.reactivex.ObservableTransformer
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers
import java.util.concurrent.TimeUnit

/**
 * @author xab
 * @create 2018-02-01 15:39
 * @desc
 */

fun <T> ioToMain(): ObservableTransformer<T, T> {
    return ObservableTransformer { upstream ->
        upstream.subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
    }
}

fun <T> newThreadToMain(): ObservableTransformer<T, T> {
    return ObservableTransformer { upstream ->
        upstream.subscribeOn(Schedulers.newThread())
            .observeOn(AndroidSchedulers.mainThread())
    }
}

fun <T> Observable<T>.register(call: (T) -> Unit): Disposable {
    return this.subscribe({ value ->
        call(value)
    }, {
        it.printStackTrace()
    })
}

fun delay(body: () -> Unit, delay: Long = 0, timeUnit: TimeUnit = TimeUnit.MILLISECONDS) {
    Observable
        .timer(delay, timeUnit)
        .compose(newThreadToMain())
        .subscribe({
            body()
        },{})
}

fun <T> Observable<T>.httpRequest(): Observable<T> = subscribeOn(Schedulers.io()).observeOn(
    AndroidSchedulers.mainThread())

fun <T> Observable<T>.timer(): Observable<T> = subscribeOn(Schedulers.newThread()).observeOn(
    AndroidSchedulers.mainThread())