/*
 * Decompiled with CFR 0.152.
 */
package cn.xabad.maya.extensions;

import android.graphics.Bitmap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"blur", "Landroid/graphics/Bitmap;", "radius", "", "extensions_release"})
public final class ImageExtKt {
    @NotNull
    public static final Bitmap blur(@NotNull Bitmap $receiver, int radius) {
        int p2;
        int p1;
        int x;
        int rSum;
        int bSum;
        int gSum;
        int y;
        int yi;
        int i;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int w = $receiver.getWidth();
        int h = $receiver.getHeight();
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vMin = new int[Math.max(w, h)];
        int[] vMax = new int[Math.max(w, h)];
        int[] pix = new int[w * h];
        $receiver.getPixels(pix, 0, w, 0, 0, w, h);
        int[] dv = new int[256 * div];
        for (i = 0; i < 256 * div; ++i) {
            dv[i] = i / div;
        }
        int yw = yi = 0;
        for (y = 0; y < h; ++y) {
            rSum = gSum = (bSum = 0);
            for (i = -radius; i <= radius; ++i) {
                int p = pix[yi + Math.min(wm, Math.max(i, 0))];
                rSum += (p & 0xFF0000) >> 16;
                gSum += (p & 0xFF00) >> 8;
                bSum += p & 0xFF;
            }
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rSum];
                g[yi] = dv[gSum];
                b[yi] = dv[bSum];
                if (y == 0) {
                    vMin[x] = Math.min(x + radius + 1, wm);
                    vMax[x] = Math.max(x - radius, 0);
                }
                p1 = pix[yw + vMin[x]];
                p2 = pix[yw + vMax[x]];
                rSum += (p1 & 0xFF0000) - (p2 & 0xFF0000) >> 16;
                gSum += (p1 & 0xFF00) - (p2 & 0xFF00) >> 8;
                bSum += (p1 & 0xFF) - (p2 & 0xFF);
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            rSum = gSum = (bSum = 0);
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                rSum += r[yi];
                gSum += g[yi];
                bSum += b[yi];
                yp += w;
            }
            yi = x;
            for (y = 0; y < h; ++y) {
                pix[yi] = (int)0xFF000000L | dv[rSum] << 16 | dv[gSum] << 8 | dv[bSum];
                if (x == 0) {
                    vMin[y] = Math.min(y + radius + 1, hm) * w;
                    vMax[y] = Math.max(y - radius, 0) * w;
                }
                p1 = x + vMin[y];
                p2 = x + vMax[y];
                rSum += r[p1] - r[p2];
                gSum += g[p1] - g[p2];
                bSum += b[p1] - b[p2];
                yi += w;
            }
        }
        $receiver.setPixels(pix, 0, w, 0, 0, w, h);
        return $receiver;
    }
}

