/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.retrofit;

import android.util.Log;
import cn.wenet.networkcomponent.convert.ToStringConverterFactory;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class NetRetrofit {
    private Retrofit mRetrofit = null;
    private Retrofit.Builder builder;
    private volatile boolean haveChange = false;

    public static NetRetrofit getInstance() {
        return new NetRetrofit();
    }

    public void setBaseUrl(String mBaseUrl) {
        this.builder.baseUrl(mBaseUrl);
        this.change();
    }

    private NetRetrofit() {
        this.init();
    }

    public Retrofit getRetrofit() {
        this.emptyBuild();
        if (null == this.mRetrofit || this.haveChange) {
            Log.e((String)"WANG", (String)"NetRetrofit.getRetrofit.\u91cd\u65b0\u521b\u5efa\u4e86\u4e00\u6b21");
            this.mRetrofit = this.builder.build();
        }
        this.haveChange = false;
        return this.mRetrofit;
    }

    public void init() {
        this.builder = new Retrofit.Builder().addConverterFactory((Converter.Factory)ToStringConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
    }

    public void transform(OkHttpClient okHttpClient) {
        this.emptyBuild();
        this.builder.client(okHttpClient);
        this.change();
    }

    private void emptyBuild() {
        if (null == this.builder) {
            throw new NullPointerException("NetRetrofit.Retrofit.Builder  is NULL !");
        }
    }

    private void change() {
        this.haveChange = true;
    }
}

