/*
 * Decompiled with CFR 0.152.
 */
package cn.wenet.networkcomponent.okhttp.intercepter;

import cn.wenet.networkcomponent.control.Control;
import cn.wenet.networkcomponent.okhttp.intercepter.BaseInterceptor;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class BaseParamsInterceptor
extends BaseInterceptor
implements Interceptor {
    private final String POST = "POST";
    private final String GET = "GET";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request oriRequest = chain.request();
        Map<String, Object> params = Control.getInstance().getParams();
        if (params.size() <= 0) {
            return chain.proceed(oriRequest);
        }
        if ("POST".equals(oriRequest.method()) && null != oriRequest.body()) {
            RequestBody body = oriRequest.body();
            FormBody newBody = null;
            if (body instanceof FormBody) {
                newBody = this.addParamsToFormBody(params, (FormBody)body);
            } else if (oriRequest.body() instanceof MultipartBody) {
                newBody = this.addParamsToMultipartBody(params, (MultipartBody)body);
            }
            if (null == newBody) {
                return chain.proceed(oriRequest);
            }
            Request.Builder builder = oriRequest.newBuilder().url(oriRequest.url()).method(oriRequest.method(), (RequestBody)newBody);
            return chain.proceed(builder.build());
        }
        if ("GET".equals(oriRequest.method())) {
            HttpUrl httpUrl = oriRequest.url();
            HttpUrl newHttpUrl = this.addParamsToHttpUrl(params, httpUrl);
            Request.Builder requestBuilder = oriRequest.newBuilder();
            requestBuilder.url(newHttpUrl);
            return chain.proceed(requestBuilder.build());
        }
        return chain.proceed(oriRequest);
    }

    private HttpUrl addParamsToHttpUrl(Map<String, Object> params, HttpUrl httpUrl) {
        HttpUrl.Builder newBuilder = httpUrl.newBuilder();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            Object value = params.get(key);
            newBuilder.addEncodedQueryParameter(key, (String)value);
        }
        return newBuilder.build();
    }

    private MultipartBody addParamsToMultipartBody(Map<String, Object> params, MultipartBody body) {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            multipartBuilder.addFormDataPart(entry.getKey(), null, RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data; charset=utf-8"), (String)((String)entry.getValue())));
        }
        return multipartBuilder.build();
    }

    private FormBody addParamsToFormBody(Map<String, Object> params, FormBody body) {
        FormBody.Builder builder = new FormBody.Builder();
        if (params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.add(entry.getKey(), (String)entry.getValue());
            }
        }
        return builder.build();
    }

    @Override
    public boolean isNetInterceptor() {
        return false;
    }
}

